/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.AnyDefNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.Context;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import tlc2.tool.BuiltInOPs;
import tlc2.value.ITupleValue;
import tlc2.value.IValue;
import tlc2.value.Values;
import util.UniqueString;

public class OpApplNode
extends ExprNode
implements ExploreNode {
    protected SymbolNode operator;
    protected ExprOrOpArgNode[] operands;
    protected FormalParamNode[] unboundedBoundSymbols;
    protected FormalParamNode[][] boundedBoundSymbols;
    protected ExprNode[] ranges;
    protected boolean[] tupleOrs;
    public SymbolNode subExpressionOf = null;

    public OpApplNode(SymbolNode sn) {
        super(9, SyntaxTreeNode.nullSTN);
        this.operator = sn;
        this.operands = new ExprNode[0];
        this.unboundedBoundSymbols = null;
        this.boundedBoundSymbols = null;
        this.ranges = new ExprNode[0];
        this.tupleOrs = null;
    }

    public OpApplNode(SymbolNode op, ExprOrOpArgNode[] oprands, TreeNode stn, ModuleNode mn, Errors errors) throws AbortException {
        super(9, stn);
        this.operator = op;
        this.operands = oprands;
        this.unboundedBoundSymbols = null;
        this.boundedBoundSymbols = null;
        this.tupleOrs = null;
        this.ranges = new ExprNode[0];
        op.match(this, mn, errors);
    }

    public OpApplNode(UniqueString us, ExprOrOpArgNode[] ops, TreeNode stn, ModuleNode mn) {
        super(9, stn);
        this.operands = ops;
        this.unboundedBoundSymbols = null;
        this.boundedBoundSymbols = null;
        this.tupleOrs = null;
        this.ranges = new ExprNode[0];
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    public OpApplNode(UniqueString us, ExprOrOpArgNode[] ops, FormalParamNode[] odns, TreeNode stn, ModuleNode mn) {
        super(9, stn);
        this.operands = ops;
        this.unboundedBoundSymbols = odns;
        this.boundedBoundSymbols = null;
        this.tupleOrs = null;
        this.ranges = new ExprNode[0];
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    public OpApplNode(UniqueString us, FormalParamNode[] funcName, ExprOrOpArgNode[] ops, FormalParamNode[][] pars, boolean[] isT, ExprNode[] rs, TreeNode stn, ModuleNode mn) {
        super(9, stn);
        this.operands = ops;
        this.unboundedBoundSymbols = funcName;
        this.boundedBoundSymbols = pars;
        this.tupleOrs = isT;
        this.ranges = rs;
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    public final SymbolNode getOperator() {
        return this.operator;
    }

    public void resetOperator(OpDefNode odn) {
        this.operator = odn;
    }

    final void resetOperator(UniqueString us) {
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    final void makeNonRecursive() {
        this.unboundedBoundSymbols = null;
    }

    public final ExprOrOpArgNode[] getArgs() {
        return this.operands;
    }

    public final void setArgs(ExprOrOpArgNode[] args) {
        this.operands = args;
    }

    public final boolean argsContainOpArgNodes() {
        for (ExprOrOpArgNode o : this.operands) {
            if (!(o instanceof OpArgNode)) continue;
            return true;
        }
        return false;
    }

    final int getNumberOfBoundedBoundSymbols() {
        if (this.boundedBoundSymbols == null) {
            return 0;
        }
        int num = 0;
        for (int i = 0; i < this.boundedBoundSymbols.length; ++i) {
            if (this.tupleOrs[i]) {
                ++num;
                continue;
            }
            num += this.boundedBoundSymbols[i].length;
        }
        return num;
    }

    public final FormalParamNode[] getUnbdedQuantSymbols() {
        return this.unboundedBoundSymbols;
    }

    public final FormalParamNode[][] getBdedQuantSymbolLists() {
        return this.boundedBoundSymbols;
    }

    public final List<FormalParamNode> getQuantSymbolLists() {
        FormalParamNode[][] bdedQuantSymbolLists;
        ArrayList<FormalParamNode> l = new ArrayList<FormalParamNode>();
        FormalParamNode[] unbdedQuantSymbols = this.getUnbdedQuantSymbols();
        if (unbdedQuantSymbols != null) {
            for (FormalParamNode s : unbdedQuantSymbols) {
                l.add(s);
            }
        }
        if ((bdedQuantSymbolLists = this.getBdedQuantSymbolLists()) != null) {
            FormalParamNode[][] formalParamNodeArray = bdedQuantSymbolLists;
            int n = formalParamNodeArray.length;
            for (int i = 0; i < n; ++i) {
                FormalParamNode[] outer;
                for (FormalParamNode inner : outer = formalParamNodeArray[i]) {
                    l.add(inner);
                }
            }
        }
        return l;
    }

    public final boolean[] isBdedQuantATuple() {
        return this.tupleOrs;
    }

    public final ExprNode[] getBdedQuantBounds() {
        return this.ranges;
    }

    private final ExprOrOpArgNode getArg(SymbolNode param) {
        AnyDefNode opDef = (AnyDefNode)((Object)this.operator);
        FormalParamNode[] formals = opDef.getParams();
        for (int i = 0; i < this.operands.length; ++i) {
            if (formals[i] != param) continue;
            return this.operands[i];
        }
        return null;
    }

    @Override
    public final boolean levelCheck(int itr, Errors errors) {
        ExprNode arg;
        String opName;
        int i;
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.levelCorrect = true;
        for (i = 0; i < this.operands.length; ++i) {
            if (this.operands[i] == null || this.operands[i].levelCheck(itr, errors)) continue;
            this.levelCorrect = false;
        }
        for (i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i] == null || this.ranges[i].levelCheck(itr, errors)) continue;
            this.levelCorrect = false;
        }
        if (this.operator instanceof AnyDefNode) {
            int i2;
            int i3;
            int i4;
            int i5;
            int i6;
            AnyDefNode opDef = (AnyDefNode)((Object)this.operator);
            boolean opDefLevelCheck = opDef.levelCheck(itr, errors);
            for (i6 = 0; i6 < this.operands.length; ++i6) {
                int j;
                ExprOrOpArgNode opd = this.operands[i6];
                if (opd == null) continue;
                if (opd.getLevel() > opDef.getMaxLevel(i6)) {
                    if (opDefLevelCheck && opd.levelCheck(itr, errors)) {
                        errors.addError(ErrorCode.OPERATOR_LEVEL_CONSTRAINTS_EXCEEDED, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe level of argument " + (i6 + 1) + " exceeds the maximum level allowed by the operator.");
                    }
                    this.levelCorrect = false;
                }
                if (!(opd instanceof OpArgNode) || !(((OpArgNode)opd).getOp() instanceof AnyDefNode)) continue;
                AnyDefNode opdDef = (AnyDefNode)((Object)((OpArgNode)opd).getOp());
                boolean opdDefLevelCheck = opdDef.levelCheck(itr, errors);
                int alen = opdDef.getArity();
                for (j = 0; j < alen; ++j) {
                    if (opdDef.getMaxLevel(j) >= opDef.getMinMaxLevel(i6, j)) continue;
                    if (opDefLevelCheck && opd.levelCheck(itr, errors)) {
                        errors.addError(ErrorCode.HIGHER_ORDER_OPERATOR_PARAMETER_LEVEL_CONSTRAINT_NOT_MET, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe permitted level of argument " + (j + 1) + " of the operator argument " + (i6 + 1) + " \nmust be at least " + opDef.getMinMaxLevel(i6, j) + ".");
                    }
                    this.levelCorrect = false;
                }
                for (j = 0; j < this.operands.length; ++j) {
                    for (int k = 0; k < alen; ++k) {
                        if (!opDef.getOpLevelCond(i6, j, k) || this.operands[j].getLevel() <= opdDef.getMaxLevel(k)) continue;
                        if (opd.levelCheck(itr, errors) && this.operands[j].levelCheck(itr, errors)) {
                            errors.addError(ErrorCode.HIGHER_ORDER_OPERATOR_COPARAMETER_LEVEL_CONSTRAINTS_EXCEEDED, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe level of argument " + (j + 1) + " exceeds the maximum level allowed by the operator.");
                        }
                        this.levelCorrect = false;
                    }
                }
            }
            for (i6 = 0; i6 < this.ranges.length; ++i6) {
                ExprNode range = this.ranges[i6];
                if (range == null) continue;
                boolean rangeLevelCheck = range.levelCheck(itr, errors);
                if (range.getLevel() <= 2) continue;
                if (rangeLevelCheck) {
                    errors.addError(ErrorCode.QUANTIFICATION_WITH_TEMPORAL_LEVEL_BOUND, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe level of the range for the bounded variable " + String.valueOf(this.boundedBoundSymbols[i6][0]) + " \nexceeds the maximum level allowed by the operator.");
                }
                this.levelCorrect = false;
            }
            this.level = opDef.getLevel();
            for (i6 = 0; i6 < this.operands.length; ++i6) {
                if (this.operands[i6] == null || opDef.getWeight(i6) != 1) continue;
                this.level = Math.max(this.level, this.operands[i6].getLevel());
            }
            for (i6 = 0; i6 < this.ranges.length; ++i6) {
                this.level = Math.max(this.level, this.ranges[i6].getLevel());
            }
            this.levelParams.addAll(opDef.getLevelParams());
            this.allParams.addAll(opDef.getAllParams());
            this.nonLeibnizParams.addAll(opDef.getNonLeibnizParams());
            int ar = opDef.getArity();
            for (i5 = 0; i5 < this.operands.length; ++i5) {
                if (this.operands[i5] != null && opDef.getWeight(i5) == 1) {
                    this.levelParams.addAll(this.operands[i5].getLevelParams());
                }
                if (this.operands[i5] != null) {
                    this.allParams.addAll(this.operands[i5].getAllParams());
                    this.nonLeibnizParams.addAll(this.operands[i5].getNonLeibnizParams());
                }
                int ii = i5;
                if (ar == -1) {
                    ii = 0;
                }
                if (opDef.getIsLeibnizArg()[ii]) continue;
                this.nonLeibnizParams.addAll(this.operands[i5].getAllParams());
            }
            for (i5 = 0; i5 < this.ranges.length; ++i5) {
                this.levelParams.addAll(this.ranges[i5].getLevelParams());
                this.allParams.addAll(this.ranges[i5].getAllParams());
                this.nonLeibnizParams.addAll(this.ranges[i5].getNonLeibnizParams());
            }
            HashSet<FormalParamNode> allBoundSymbols = new HashSet<FormalParamNode>();
            if (this.unboundedBoundSymbols != null) {
                for (int i7 = 0; i7 < this.unboundedBoundSymbols.length; ++i7) {
                    allBoundSymbols.add(this.unboundedBoundSymbols[i7]);
                }
            }
            if (this.boundedBoundSymbols != null) {
                for (int i8 = 0; i8 < this.boundedBoundSymbols.length; ++i8) {
                    if (this.boundedBoundSymbols[i8] == null) continue;
                    for (int j = 0; j < this.boundedBoundSymbols[i8].length; ++j) {
                        allBoundSymbols.add(this.boundedBoundSymbols[i8][j]);
                    }
                }
            }
            for (FormalParamNode nextBoundSymbol : allBoundSymbols) {
                this.levelParams.remove(nextBoundSymbol);
                this.allParams.remove(nextBoundSymbol);
                this.nonLeibnizParams.remove(nextBoundSymbol);
            }
            this.levelConstraints.putAll(opDef.getLevelConstraints());
            for (i4 = 0; i4 < this.operands.length; ++i4) {
                if (this.operands[i4] == null) continue;
                if (allBoundSymbols.size() == 0) {
                    this.levelConstraints.putAll(this.operands[i4].getLevelConstraints());
                    continue;
                }
                SetOfLevelConstraints lcons = this.operands[i4].getLevelConstraints();
                for (SymbolNode param : lcons.keySet()) {
                    if (allBoundSymbols.contains(param)) continue;
                    this.levelConstraints.put(param, (Integer)lcons.get(param));
                }
            }
            for (i4 = 0; i4 < this.ranges.length; ++i4) {
                this.levelConstraints.putAll(this.ranges[i4].getLevelConstraints());
            }
            for (i4 = 0; i4 < this.operands.length; ++i4) {
                Integer mlevel = opDef.getMaxLevel(i4);
                if (this.operands[i4] == null) continue;
                Iterator<SymbolNode> iter = this.operands[i4].getLevelParams().iterator();
                while (iter.hasNext()) {
                    this.levelConstraints.put(iter.next(), mlevel);
                }
            }
            for (i4 = 0; i4 < this.operands.length; ++i4) {
                int k;
                int j;
                ExprOrOpArgNode opdi = this.operands[i4];
                if (opdi == null || !(opdi instanceof OpArgNode) || !(((OpArgNode)opdi).getOp() instanceof AnyDefNode)) continue;
                AnyDefNode argDef = (AnyDefNode)((Object)((OpArgNode)opdi).getOp());
                argDef.levelCheck(itr, errors);
                int alen = argDef.getArity();
                for (j = 0; j < this.operands.length; ++j) {
                    for (k = 0; k < alen; ++k) {
                        if (!opDef.getOpLevelCond(i4, j, k)) continue;
                        Integer mlevel = argDef.getMaxLevel(k);
                        Iterator<SymbolNode> iter = this.operands[j].getLevelParams().iterator();
                        while (iter.hasNext()) {
                            this.levelConstraints.put(iter.next(), mlevel);
                        }
                    }
                }
                if (argDef.getIsLeibniz()) continue;
                for (j = 0; j < this.operands.length; ++j) {
                    for (k = 0; k < alen; ++k) {
                        if (!opDef.getOpLevelCond(i4, j, k) || argDef.getIsLeibnizArg()[k]) continue;
                        this.nonLeibnizParams.addAll(this.operands[j].getAllParams());
                    }
                }
            }
            HashSet<ArgLevelParam> alpSet = opDef.getArgLevelParams();
            for (ArgLevelParam alp : alpSet) {
                ExprOrOpArgNode arg2 = this.getArg(alp.op);
                if (arg2 == null || !(arg2 instanceof OpArgNode) || !(((OpArgNode)arg2).getOp() instanceof AnyDefNode)) continue;
                AnyDefNode argDef = (AnyDefNode)((Object)((OpArgNode)arg2).getOp());
                argDef.levelCheck(itr, errors);
                Integer mlevel = argDef.getMaxLevel(alp.i);
                this.levelConstraints.put(alp.param, mlevel);
            }
            this.argLevelConstraints.putAll(opDef.getArgLevelConstraints());
            for (i3 = 0; i3 < this.operands.length; ++i3) {
                if (this.operands[i3] == null) continue;
                this.argLevelConstraints.putAll(this.operands[i3].getArgLevelConstraints());
            }
            for (i3 = 0; i3 < this.ranges.length; ++i3) {
                this.argLevelConstraints.putAll(this.ranges[i3].getArgLevelConstraints());
            }
            for (i3 = 0; i3 < this.operands.length; ++i3) {
                int j;
                ExprOrOpArgNode opdi = this.operands[i3];
                if (opdi == null || !(opdi instanceof OpArgNode) || !((OpArgNode)opdi).getOp().isParam()) continue;
                SymbolNode opArg = ((OpArgNode)opdi).getOp();
                int alen = opArg.getArity();
                for (j = 0; j < alen; ++j) {
                    ParamAndPosition pap = new ParamAndPosition(opArg, j);
                    Integer mlevel = opDef.getMinMaxLevel(i3, j);
                    this.argLevelConstraints.put(pap, mlevel);
                }
                for (j = 0; j < this.operands.length; ++j) {
                    for (int k = 0; k < alen; ++k) {
                        if (!opDef.getOpLevelCond(i3, j, k)) continue;
                        ParamAndPosition pap = new ParamAndPosition(opArg, k);
                        Integer mlevel = this.operands[j].getLevel();
                        this.argLevelConstraints.put(pap, mlevel);
                    }
                }
            }
            for (ArgLevelParam alp : alpSet) {
                ExprOrOpArgNode arg3 = this.getArg(alp.op);
                if (arg3 == null) continue;
                arg3.levelCheck(itr, errors);
                ParamAndPosition pap = new ParamAndPosition(alp.op, alp.i);
                this.argLevelConstraints.put(pap, arg3.getLevel());
            }
            this.argLevelParams = new HashSet();
            for (i2 = 0; i2 < this.operands.length; ++i2) {
                if (this.operands[i2] == null) continue;
                if (allBoundSymbols.size() == 0) {
                    this.argLevelParams.addAll(this.operands[i2].getArgLevelParams());
                    continue;
                }
                for (ArgLevelParam alp : this.operands[i2].getArgLevelParams()) {
                    if (allBoundSymbols.contains(alp.param)) continue;
                    this.argLevelParams.add(alp);
                }
            }
            for (i2 = 0; i2 < this.ranges.length; ++i2) {
                this.argLevelParams.addAll(this.ranges[i2].getArgLevelParams());
            }
            for (ArgLevelParam alp : alpSet) {
                ExprOrOpArgNode arg4 = this.getArg(alp.op);
                if (arg4 == null) {
                    arg4 = this.getArg(alp.param);
                    if (arg4 == null) {
                        this.argLevelParams.add(alp);
                        continue;
                    }
                    arg4.levelCheck(itr, errors);
                    for (SymbolNode param : arg4.getLevelParams()) {
                        this.argLevelParams.add(new ArgLevelParam(alp.op, alp.i, param));
                    }
                    continue;
                }
                if (!(arg4 instanceof OpArgNode) || !((OpArgNode)arg4).getOp().isParam()) continue;
                SymbolNode argOp = ((OpArgNode)arg4).getOp();
                this.argLevelParams.add(new ArgLevelParam(argOp, alp.i, alp.param));
            }
            for (int i9 = 0; i9 < this.operands.length; ++i9) {
                ExprOrOpArgNode opdi = this.operands[i9];
                if (opdi == null || !(opdi instanceof OpArgNode) || !((OpArgNode)opdi).getOp().isParam()) continue;
                SymbolNode opArg = ((OpArgNode)opdi).getOp();
                int alen = opArg.getArity();
                for (int j = 0; j < this.operands.length; ++j) {
                    for (int k = 0; k < alen; ++k) {
                        if (!opDef.getOpLevelCond(i9, j, k)) continue;
                        for (SymbolNode param : this.operands[j].getLevelParams()) {
                            this.argLevelParams.add(new ArgLevelParam(opArg, k, param));
                        }
                    }
                }
            }
        } else {
            this.operator.levelCheck(itr, errors);
            this.level = this.operator.getLevel();
            for (i = 0; i < this.operands.length; ++i) {
                this.operands[i].levelCheck(itr, errors);
                this.level = Math.max(this.level, this.operands[i].getLevel());
            }
            this.levelParams = new HashSet();
            this.levelParams.add(this.operator);
            this.allParams.add(this.operator);
            for (i = 0; i < this.operands.length; ++i) {
                this.levelParams.addAll(this.operands[i].getLevelParams());
                this.allParams.addAll(this.operands[i].getAllParams());
                this.nonLeibnizParams.addAll(this.operands[i].getNonLeibnizParams());
            }
            this.levelConstraints = new SetOfLevelConstraints();
            for (i = 0; i < this.operands.length; ++i) {
                this.levelConstraints.putAll(this.operands[i].getLevelConstraints());
            }
            this.argLevelConstraints = new SetOfArgLevelConstraints();
            for (i = 0; i < this.operands.length; ++i) {
                this.argLevelConstraints.put(this.operator, i, this.operands[i].getLevel());
                this.argLevelConstraints.putAll(this.operands[i].getArgLevelConstraints());
            }
            this.argLevelParams = new HashSet();
            for (i = 0; i < this.operands.length; ++i) {
                HashSet<SymbolNode> lpSet = this.operands[i].getLevelParams();
                for (SymbolNode param : lpSet) {
                    this.argLevelParams.add(new ArgLevelParam(this.operator, i, param));
                }
                this.argLevelParams.addAll(this.operands[i].getArgLevelParams());
            }
        }
        if ((opName = this.operator.getName().toString()).equals("[]") && (arg = (ExprNode)this.getArgs()[0]).getLevel() == 2 && arg.getKind() == 9 && !((OpApplNode)arg).operator.getName().toString().equals("$SquareAct")) {
            errors.addError(ErrorCode.ALWAYS_PROPERTY_SENSITIVE_TO_STUTTERING, this.stn.getLocation(), "[] followed by action not of form [A]_v.");
            this.levelCorrect = false;
        }
        if (opName.equals("<>") && (arg = (ExprNode)this.getArgs()[0]).getLevel() == 2 && arg.getKind() == 9 && !((OpApplNode)arg).operator.getName().toString().equals("$AngleAct")) {
            errors.addError(ErrorCode.EVENTUALLY_PROPERTY_SENSITIVE_TO_STUTTERING, this.stn.getLocation(), "<> followed by action not of form <<A>>_v.");
            this.levelCorrect = false;
        }
        if ((opName.equals("~>") || opName.equals("-+->")) && (this.getArgs()[0].getLevel() == 2 || this.getArgs()[1].getLevel() == 2)) {
            errors.addError(ErrorCode.BINARY_TEMPORAL_OPERATOR_WITH_ACTION_LEVEL_PARAMETER, this.stn.getLocation(), "Action used where only temporal formula or state predicate allowed.");
            this.levelCorrect = false;
        }
        if (opName.equals("\\land") || opName.equals("\\lor") || opName.equals("=>") || opName.equals("\\equiv") || opName.equals("$ConjList") || opName.equals("$DisjList")) {
            boolean hasTemporal = false;
            boolean hasAction = false;
            for (int i10 = 0; i10 < this.getArgs().length; ++i10) {
                hasTemporal = hasTemporal || this.getArgs()[i10].getLevel() == 3;
                hasAction = hasAction || this.getArgs()[i10].getLevel() == 2;
            }
            if (hasTemporal && hasAction) {
                String pop = opName;
                if (pop.equals("$ConjList")) {
                    pop = "Conjunction list";
                }
                if (pop.equals("$DisjList")) {
                    pop = "Disjunction list";
                }
                errors.addError(ErrorCode.LOGICAL_OPERATOR_WITH_MIXED_ACTION_TEMPORAL_PARAMETERS, this.stn.getLocation(), pop + " has both temporal formula and action as arguments.");
                this.levelCorrect = false;
            }
        }
        if (this.level == 3 && (opName.equals("$BoundedExists") || opName.equals("$BoundedForall"))) {
            for (int i11 = 0; i11 < this.ranges.length; ++i11) {
                if (this.ranges[i11].getLevel() != 2) continue;
                errors.addError(ErrorCode.QUANTIFIED_TEMPORAL_FORMULA_WITH_ACTION_LEVEL_BOUND, this.ranges[i11].stn.getLocation(), "Action-level bound of quantified temporal formula.");
                this.levelCorrect = false;
            }
        }
        return this.levelCorrect;
    }

    public boolean hasOpcode(int opCode) {
        return opCode == BuiltInOPs.getOpCode(this.getOperator().getName());
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.ranges.length + this.operands.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            res[i] = this.ranges[i];
        }
        for (int j = 0; j < this.operands.length; ++j) {
            res[i + j] = this.operands[j];
        }
        return res;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        int i;
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.operator != null) {
            this.operator.walkGraph(semNodesTable, visitor);
        }
        if (this.unboundedBoundSymbols != null && this.unboundedBoundSymbols.length > 0) {
            for (i = 0; i < this.unboundedBoundSymbols.length; ++i) {
                if (this.unboundedBoundSymbols[i] == null) continue;
                this.unboundedBoundSymbols[i].walkGraph(semNodesTable, visitor);
            }
        }
        if (this.operands != null && this.operands.length > 0) {
            for (i = 0; i < this.operands.length; ++i) {
                if (this.operands[i] == null) continue;
                this.operands[i].walkGraph(semNodesTable, visitor);
            }
        }
        if (this.ranges.length > 0) {
            for (i = 0; i < this.ranges.length; ++i) {
                if (this.ranges[i] == null) continue;
                this.ranges[i].walkGraph(semNodesTable, visitor);
            }
        }
        if (this.boundedBoundSymbols != null && this.boundedBoundSymbols.length > 0) {
            for (i = 0; i < this.boundedBoundSymbols.length; ++i) {
                if (this.boundedBoundSymbols[i] == null || this.boundedBoundSymbols[i].length <= 0) continue;
                for (int j = 0; j < this.boundedBoundSymbols[i].length; ++j) {
                    if (this.boundedBoundSymbols[i][j] == null) continue;
                    this.boundedBoundSymbols[i][j].walkGraph(semNodesTable, visitor);
                }
            }
        }
        visitor.postVisit(this);
    }

    private String toStringBody(int depth, Errors errors) {
        int i;
        if (depth <= 1) {
            return "";
        }
        Object ret = this.operator == null ? "\nOperator: null" : "\nOperator: " + this.operator.getName().toString() + "  " + this.operator.getUid() + "  ";
        if (this.unboundedBoundSymbols != null && this.unboundedBoundSymbols.length > 0) {
            ret = (String)ret + "\nUnbounded bound symbols:  ";
            for (i = 0; i < this.unboundedBoundSymbols.length; ++i) {
                ret = (String)ret + Strings.indent(2, this.unboundedBoundSymbols[i].toString(depth - 1, errors));
            }
        }
        if (this.boundedBoundSymbols != null && this.boundedBoundSymbols.length > 0) {
            ret = (String)ret + "\nBounded bound symbols: " + this.getNumberOfBoundedBoundSymbols();
            for (i = 0; i < this.boundedBoundSymbols.length; ++i) {
                if (this.boundedBoundSymbols[i] == null || this.boundedBoundSymbols[i].length <= 0) continue;
                for (int j = 0; j < this.boundedBoundSymbols[i].length; ++j) {
                    ret = (String)ret + Strings.indent(2, "\n[" + i + "," + j + "]" + Strings.indent(2, this.boundedBoundSymbols[i][j].toString(depth - 1, errors)));
                }
            }
        }
        if (this.ranges.length > 0) {
            ret = (String)ret + "\nRanges: ";
            for (i = 0; i < this.ranges.length; ++i) {
                ret = (String)ret + Strings.indent(2, this.ranges[i] != null ? this.ranges[i].toString(depth - 1, errors) : "null");
            }
        }
        if (this.tupleOrs != null && this.tupleOrs.length > 0) {
            ret = (String)ret + "\nTupleOrs:   ";
            for (i = 0; i < this.tupleOrs.length; ++i) {
                ret = (String)ret + Strings.indent(2, this.tupleOrs[i] ? "\ntrue" : "\nfalse");
            }
        }
        if (this.operands != null) {
            if (this.operands.length > 0) {
                ret = (String)ret + "\nOperands: " + this.operands.length;
                for (i = 0; i < this.operands.length; ++i) {
                    ret = (String)ret + Strings.indent(2, this.operands[i] == null ? "\nnull" : this.operands[i].toString(depth - 1, errors));
                }
            }
        } else {
            ret = (String)ret + "\nOperands: null";
        }
        return Strings.indent(2, (String)ret);
    }

    @Override
    public String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String sEO = "";
        if (this.subExpressionOf != null) {
            sEO = Strings.indent(2, "\nsubExpressionOf: " + Strings.indent(2, this.subExpressionOf.toString(1, errors)));
        }
        return "\n*OpApplNode: " + String.valueOf(this.operator.getName()) + "  " + super.toString(depth + 1, errors) + "  errors: " + (errors != null ? "non-null" : "null") + this.toStringBody(depth, errors) + sEO;
    }

    @Override
    public String toString(IValue aValue) {
        if (aValue instanceof ITupleValue && this.allParams.size() == ((ITupleValue)aValue).size()) {
            StringBuffer result = new StringBuffer();
            TreeSet<SymbolNode> s = new TreeSet<SymbolNode>(new Comparator<SymbolNode>(){

                @Override
                public int compare(SymbolNode o1, SymbolNode o2) {
                    return Integer.compare(o1.getName().getVarLoc(), o2.getName().getVarLoc());
                }
            });
            s.addAll(this.allParams);
            int idx = 0;
            for (SymbolNode sn : s) {
                result.append("/\\ ");
                result.append(sn.getName().toString());
                IValue value = ((ITupleValue)aValue).getElem(idx++);
                result.append(" = ");
                result.append(Values.ppr(value));
                result.append("\n");
            }
            return result.toString();
        }
        return super.toString(aValue);
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        OpApplNode other;
        ExprOrOpArgNode lastOperand;
        Element e = doc.createElement("OpApplNode");
        if (this.operator.getName().toString().equals("$Case") && this.operands.length > 1 && (lastOperand = this.operands[this.operands.length - 1]) instanceof OpApplNode && (other = (OpApplNode)lastOperand).getOperator().getName().toString().equals("$Pair") && other.getArgs()[0] == null) {
            context = new SymbolContext(context);
            context.setFlag(0);
        }
        Element op = doc.createElement("operator");
        op.appendChild(this.operator.export(doc, context, filter));
        e.appendChild(op);
        Element ope = doc.createElement("operands");
        for (int i = 0; i < this.operands.length; ++i) {
            if (i == 0 && this.operands[0] == null && context.hasFlag(0)) {
                ope.appendChild(this.appendText(doc, "StringNode", "$Other"));
                continue;
            }
            ope.appendChild(this.operands[i].export(doc, context, filter));
        }
        e.appendChild(ope);
        if (this.unboundedBoundSymbols != null | this.boundedBoundSymbols != null) {
            Element bvar;
            int i;
            Element bvars = doc.createElement("boundSymbols");
            if (this.unboundedBoundSymbols != null) {
                for (i = 0; i < this.unboundedBoundSymbols.length; ++i) {
                    bvar = doc.createElement("unbound");
                    bvar.appendChild(this.unboundedBoundSymbols[i].export(doc, context, filter));
                    if (this.tupleOrs != null && this.tupleOrs[i]) {
                        bvar.appendChild(doc.createElement("tuple"));
                    }
                    bvars.appendChild(bvar);
                }
            }
            if (this.boundedBoundSymbols != null) {
                for (i = 0; i < this.boundedBoundSymbols.length; ++i) {
                    bvar = doc.createElement("bound");
                    for (int j = 0; j < this.boundedBoundSymbols[i].length; ++j) {
                        bvar.appendChild(this.boundedBoundSymbols[i][j].export(doc, context, filter));
                    }
                    if (this.tupleOrs != null && this.tupleOrs[i]) {
                        bvar.appendChild(doc.createElement("tuple"));
                    }
                    bvar.appendChild(this.ranges[i].export(doc, context, filter));
                    bvars.appendChild(bvar);
                }
            }
            e.appendChild(bvars);
        }
        return e;
    }
}

