/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.PCalLocation;
import pcal.ParseAlgorithm;
import pcal.PcalDebug;
import pcal.PcalSymTab;
import pcal.Region;
import pcal.TLAExpr;
import pcal.TLAToken;
import pcal.exception.PcalTranslateException;

public class PcalTranslate {
    private static PcalSymTab st = null;
    private static String currentProcedure;

    public static Vector DiscardLastElement(Vector v) {
        if (v.size() > 0) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public static Vector Singleton(Object obj) {
        Vector<Object> result = new Vector<Object>();
        result.addElement(obj);
        return result;
    }

    public static Vector Pair(Object obj1, Object obj2) {
        Vector<Object> result = new Vector<Object>();
        result.addElement(obj1);
        result.addElement(obj2);
        return result;
    }

    public static Vector Triple(Object obj1, Object obj2, Object obj3) {
        Vector<Object> result = new Vector<Object>();
        result.addElement(obj1);
        result.addElement(obj2);
        result.addElement(obj3);
        return result;
    }

    public static Vector Singleton2(Object obj) {
        return PcalTranslate.Singleton(PcalTranslate.Singleton(obj));
    }

    public static BoolObj BO(boolean v) {
        BoolObj res = new BoolObj();
        res.val = v;
        return res;
    }

    public static TLAToken StringToken(String str) {
        TLAToken result = new TLAToken();
        result.string = str;
        result.type = 3;
        return result;
    }

    public static TLAToken AddedToken(String str) {
        TLAToken result = new TLAToken();
        result.string = str;
        result.type = 5;
        return result;
    }

    public static TLAToken BuiltInToken(String str) {
        TLAToken result = new TLAToken();
        result.string = str;
        result.type = 1;
        return result;
    }

    public static TLAToken IdentToken(String str) {
        TLAToken result = new TLAToken();
        result.string = str;
        result.type = 4;
        return result;
    }

    public static TLAExpr MakeExpr(Vector vec) {
        TLAExpr result = new TLAExpr(vec);
        result.normalize();
        return result;
    }

    public static TLAExpr TokVectorToExpr(Vector vec, int spaces) {
        Vector<TLAToken> firstLine = new Vector<TLAToken>();
        int nextCol = 0;
        for (int i = 0; i < vec.size(); ++i) {
            TLAToken tok = new TLAToken((TLAToken)vec.elementAt(i));
            tok.column = nextCol;
            firstLine.addElement(tok);
            nextCol = nextCol + tok.getWidth() + spaces;
        }
        return PcalTranslate.MakeExpr(PcalTranslate.Singleton(firstLine));
    }

    public static void MakeNewStackTopExprPretty(TLAExpr expr) {
        int nextCol = 0;
        for (int i = 0; i < expr.tokens.size(); ++i) {
            Vector<TLAToken> line = expr.tokens.elementAt(i);
            nextCol = i == 0 || i == expr.tokens.size() - 1 ? 1 : 6;
            for (int j = 0; j < line.size(); ++j) {
                TLAToken tok = line.elementAt(j);
                tok.column = nextCol;
                nextCol += tok.getWidth();
                if (tok.type == 1 && (tok.string.equals("|->") || tok.string.equals("\u21a6"))) {
                    ++tok.column;
                    if (tok.column < 16) {
                        tok.column = 16;
                    }
                    nextCol = tok.column + 5;
                    continue;
                }
                if (tok.type == 1 && tok.string.equals("[")) {
                    ++nextCol;
                    continue;
                }
                if (tok.type == 1 && tok.string.equals("]")) {
                    ++tok.column;
                    ++nextCol;
                    continue;
                }
                if (tok.type == 1 && tok.string.equals("<<")) {
                    ++nextCol;
                    continue;
                }
                if (tok.type == 1 && tok.string.equals(">>")) {
                    ++tok.column;
                    ++nextCol;
                    continue;
                }
                if (tok.type != 1 || !tok.string.equals("\\o")) continue;
                ++tok.column;
                nextCol += 2;
            }
        }
    }

    public static AST.Assign MakeAssign(String id, TLAExpr exp) {
        AST.SingleAssign sAss = new AST.SingleAssign();
        sAss.lhs.var = id;
        sAss.lhs.sub = PcalTranslate.MakeExpr(new Vector());
        sAss.rhs = exp;
        AST.Assign result = new AST.Assign();
        result.ass = PcalTranslate.Singleton(sAss);
        return result;
    }

    public static boolean IsTRUE(TLAExpr expr) {
        Vector<Vector<TLAToken>> tokens = expr.tokens;
        if (tokens.size() > 1) {
            return false;
        }
        Vector<TLAToken> line = tokens.elementAt(0);
        if (line.size() == 1) {
            TLAToken tok = line.elementAt(0);
            return tok.string.equals("TRUE");
        }
        if (line.size() == 3) {
            TLAToken tok1 = line.elementAt(0);
            TLAToken tok2 = line.elementAt(1);
            TLAToken tok3 = line.elementAt(2);
            return tok1.string.equals("(") && tok2.string.equals("TRUE") && tok3.string.equals(")");
        }
        return false;
    }

    private static AST.When CheckPC(String label) {
        AST.When checkPC = new AST.When();
        Vector<TLAToken> toks = new Vector<TLAToken>();
        toks.addElement(PcalTranslate.AddedToken("pc"));
        toks.addElement(PcalTranslate.BuiltInToken("="));
        toks.addElement(PcalTranslate.StringToken(label));
        checkPC.exp = PcalTranslate.TokVectorToExpr(toks, 1);
        return checkPC;
    }

    private static AST.Assign UpdatePC(String next) {
        return PcalTranslate.MakeAssign("pc", PcalTranslate.MakeExpr(PcalTranslate.Singleton2(PcalTranslate.StringToken(next))));
    }

    @Deprecated
    private static AST.If IfForLabelIf(TLAExpr test, Vector unlabThen, String nextThen, Vector unlabElse, String nextElse) {
        AST.If ifForLabelIf = new AST.If();
        ifForLabelIf.test = test;
        ifForLabelIf.Then = unlabThen;
        ifForLabelIf.Then.addElement(PcalTranslate.UpdatePC(nextThen));
        ifForLabelIf.Else = unlabElse;
        ifForLabelIf.Else.addElement(PcalTranslate.UpdatePC(nextElse));
        return ifForLabelIf;
    }

    public static AST Explode(AST ast, PcalSymTab symtab) throws PcalTranslateException {
        st = symtab;
        currentProcedure = null;
        if (ast.getClass().equals(AST.UniprocessObj.getClass())) {
            return PcalTranslate.ExplodeUniprocess((AST.Uniprocess)ast);
        }
        if (ast.getClass().equals(AST.MultiprocessObj.getClass())) {
            return PcalTranslate.ExplodeMultiprocess((AST.Multiprocess)ast);
        }
        PcalDebug.ReportBug("Unexpected AST type.");
        return null;
    }

    private static AST.Uniprocess ExplodeUniprocess(AST.Uniprocess ast) throws PcalTranslateException {
        AST.LabeledStmt nextLS;
        int i = 0;
        AST.Uniprocess newast = new AST.Uniprocess();
        newast.col = ast.col;
        newast.line = ast.line;
        newast.name = ast.name;
        newast.decls = ast.decls;
        newast.prcds = new Vector(ast.prcds.size(), 10);
        newast.defs = ast.defs;
        newast.setOrigin(ast.getOrigin());
        for (i = 0; i < ast.prcds.size(); ++i) {
            newast.prcds.addElement(PcalTranslate.ExplodeProcedure((AST.Procedure)ast.prcds.elementAt(i)));
        }
        i = 0;
        newast.body = new Vector(ast.body.size(), 10);
        AST.LabeledStmt thisLS = ast.body.size() > 0 ? (AST.LabeledStmt)ast.body.elementAt(0) : null;
        AST.LabeledStmt labeledStmt = nextLS = ast.body.size() > 1 ? (AST.LabeledStmt)ast.body.elementAt(1) : null;
        while (i < ast.body.size()) {
            String next = nextLS == null ? "Done" : nextLS.label;
            newast.body.addAll(PcalTranslate.ExplodeLabeledStmt(thisLS, next));
            thisLS = nextLS;
            nextLS = ast.body.size() > ++i + 1 ? (AST.LabeledStmt)ast.body.elementAt(i + 1) : null;
        }
        return newast;
    }

    private static AST.Multiprocess ExplodeMultiprocess(AST.Multiprocess ast) throws PcalTranslateException {
        int i;
        AST.Multiprocess newast = new AST.Multiprocess();
        newast.col = ast.col;
        newast.line = ast.line;
        newast.name = ast.name;
        newast.decls = ast.decls;
        newast.prcds = new Vector(ast.prcds.size(), 10);
        newast.defs = ast.defs;
        newast.setOrigin(ast.getOrigin());
        for (i = 0; i < ast.prcds.size(); ++i) {
            newast.prcds.addElement(PcalTranslate.ExplodeProcedure((AST.Procedure)ast.prcds.elementAt(i)));
        }
        newast.procs = new Vector(ast.procs.size(), 10);
        for (i = 0; i < ast.procs.size(); ++i) {
            newast.procs.addElement(PcalTranslate.ExplodeProcess((AST.Process)ast.procs.elementAt(i)));
        }
        return newast;
    }

    private static AST ExplodeProcedure(AST.Procedure ast) throws PcalTranslateException {
        AST.LabeledStmt nextLS;
        int i = 0;
        AST.Procedure newast = new AST.Procedure();
        newast.setOrigin(ast.getOrigin());
        newast.col = ast.col;
        newast.line = ast.line;
        newast.name = ast.name;
        currentProcedure = ast.name;
        newast.params = ast.params;
        newast.decls = ast.decls;
        newast.body = new Vector(ast.body.size(), 10);
        AST.LabeledStmt thisLS = ast.body.size() > 0 ? (AST.LabeledStmt)ast.body.elementAt(0) : null;
        AST.LabeledStmt labeledStmt = nextLS = ast.body.size() > 1 ? (AST.LabeledStmt)ast.body.elementAt(1) : null;
        while (i < ast.body.size()) {
            String next = nextLS == null ? st.UseThis(1, "Error", "") : nextLS.label;
            newast.body.addAll(PcalTranslate.ExplodeLabeledStmt(thisLS, next));
            thisLS = nextLS;
            nextLS = ast.body.size() > ++i + 1 ? (AST.LabeledStmt)ast.body.elementAt(i + 1) : null;
        }
        currentProcedure = null;
        return newast;
    }

    private static AST ExplodeProcess(AST.Process ast) throws PcalTranslateException {
        AST.LabeledStmt nextLS;
        int i = 0;
        AST.Process newast = new AST.Process();
        newast.setOrigin(ast.getOrigin());
        newast.col = ast.col;
        newast.line = ast.line;
        newast.name = ast.name;
        newast.isEq = ast.isEq;
        newast.id = ast.id;
        newast.decls = ast.decls;
        newast.body = new Vector();
        AST.LabeledStmt thisLS = ast.body.size() > 0 ? (AST.LabeledStmt)ast.body.elementAt(0) : null;
        AST.LabeledStmt labeledStmt = nextLS = ast.body.size() > 1 ? (AST.LabeledStmt)ast.body.elementAt(1) : null;
        while (i < ast.body.size()) {
            String next = nextLS == null ? "Done" : nextLS.label;
            newast.body.addAll(PcalTranslate.ExplodeLabeledStmt(thisLS, next));
            thisLS = nextLS;
            nextLS = ast.body.size() > ++i + 1 ? (AST.LabeledStmt)ast.body.elementAt(i + 1) : null;
        }
        return newast;
    }

    private static Vector CopyAndExplodeLastStmt(Vector stmts, String next) throws PcalTranslateException {
        Vector result1 = new Vector();
        Vector result2 = new Vector();
        boolean needsGoto = false;
        if (stmts != null && stmts.size() > 0) {
            AST last = (AST)stmts.elementAt(stmts.size() - 1);
            result1 = stmts;
            if (last.getClass().equals(AST.LabelIfObj.getClass())) {
                Vector pair2 = PcalTranslate.ExplodeLabelIf((AST.LabelIf)last, next);
                result1.removeElementAt(result1.size() - 1);
                result1.addAll((Vector)pair2.elementAt(0));
                result2 = (Vector)pair2.elementAt(1);
            } else if (last.getClass().equals(AST.LabelEitherObj.getClass())) {
                Vector pair3 = PcalTranslate.ExplodeLabelEither((AST.LabelEither)last, next);
                result1.removeElementAt(result1.size() - 1);
                result1.addAll((Vector)pair3.elementAt(0));
                result2 = (Vector)pair3.elementAt(1);
            } else if (last.getClass().equals(AST.GotoObj.getClass())) {
                AST.Goto g = (AST.Goto)last;
                result1.removeElementAt(result1.size() - 1);
                result1.addElement(PcalTranslate.UpdatePC(g.to));
            } else if (last.getClass().equals(AST.CallObj.getClass())) {
                result1.removeElementAt(result1.size() - 1);
                result1.addAll(PcalTranslate.ExplodeCall((AST.Call)last, next));
            } else if (last.getClass().equals(AST.ReturnObj.getClass())) {
                result1.removeElementAt(result1.size() - 1);
                result1.addAll(PcalTranslate.ExplodeReturn((AST.Return)last, next));
            } else if (last.getClass().equals(AST.CallReturnObj.getClass())) {
                result1.removeElementAt(result1.size() - 1);
                result1.addAll(PcalTranslate.ExplodeCallReturn((AST.CallReturn)last, next));
            } else if (last.getClass().equals(AST.CallGotoObj.getClass())) {
                result1.removeElementAt(result1.size() - 1);
                result1.addAll(PcalTranslate.ExplodeCallGoto((AST.CallGoto)last, next));
            } else if (last.getClass().equals(AST.IfObj.getClass())) {
                AST.If If2 = (AST.If)last;
                Vector p1 = PcalTranslate.CopyAndExplodeLastStmt(If2.Then, next);
                Vector p2 = PcalTranslate.CopyAndExplodeLastStmt(If2.Else, next);
                result2.addAll((Vector)p1.elementAt(1));
                result2.addAll((Vector)p2.elementAt(1));
                If2.Then = (Vector)p1.elementAt(0);
                If2.Else = (Vector)p2.elementAt(0);
                if (!ParseAlgorithm.omitPC) {
                    boolean thenNeedsGoto = ((BoolObj)p1.elementAt((int)2)).val;
                    boolean elseNeedsGoto = ((BoolObj)p2.elementAt((int)2)).val;
                    boolean bl = needsGoto = thenNeedsGoto && elseNeedsGoto;
                    if (!needsGoto) {
                        if (thenNeedsGoto) {
                            If2.Then.addElement(PcalTranslate.UpdatePC(next));
                        }
                        if (elseNeedsGoto) {
                            If2.Else.addElement(PcalTranslate.UpdatePC(next));
                        }
                    }
                }
            } else if (last.getClass().equals(AST.EitherObj.getClass())) {
                int i;
                needsGoto = true;
                Vector needsGotoVec = new Vector();
                AST.Either Either2 = (AST.Either)last;
                for (i = 0; i < Either2.ors.size(); ++i) {
                    Vector thisP = PcalTranslate.CopyAndExplodeLastStmt((Vector)Either2.ors.elementAt(i), next);
                    Either2.ors.setElementAt(thisP.elementAt(0), i);
                    result2.addAll((Vector)thisP.elementAt(1));
                    needsGoto = needsGoto && ((BoolObj)thisP.elementAt((int)2)).val;
                    needsGotoVec.addElement(thisP.elementAt(2));
                }
                if (!ParseAlgorithm.omitPC && !needsGoto) {
                    for (i = 0; i < Either2.ors.size(); ++i) {
                        if (!((BoolObj)needsGotoVec.elementAt((int)i)).val) continue;
                        ((Vector)Either2.ors.elementAt(i)).addElement(PcalTranslate.UpdatePC(next));
                    }
                }
            } else if (last.getClass().equals(AST.WithObj.getClass())) {
                AST.With with = (AST.With)last;
                Vector p = PcalTranslate.CopyAndExplodeLastStmt(with.Do, next);
                with.Do = (Vector)p.elementAt(0);
                result2.addAll((Vector)p.elementAt(1));
                needsGoto = ((BoolObj)p.elementAt((int)2)).val;
            } else {
                needsGoto = true;
            }
        } else {
            needsGoto = true;
        }
        if (ParseAlgorithm.omitPC) {
            needsGoto = false;
        }
        return PcalTranslate.Triple(result1, result2, PcalTranslate.BO(needsGoto));
    }

    private static Vector CopyAndExplodeLastStmtWithGoto(Vector stmts, String next) throws PcalTranslateException {
        Vector res = PcalTranslate.CopyAndExplodeLastStmt(stmts, next);
        if (((BoolObj)res.elementAt((int)2)).val) {
            ((Vector)res.elementAt(0)).addElement(PcalTranslate.UpdatePC(next));
        }
        return PcalTranslate.Pair(res.elementAt(0), res.elementAt(1));
    }

    private static Vector ExplodeLabeledStmt(AST.LabeledStmt ast, String next) throws PcalTranslateException {
        if (ast.stmts.size() > 0 && ast.stmts.elementAt(0).getClass().equals(AST.WhileObj.getClass())) {
            return PcalTranslate.ExplodeWhile(ast, next);
        }
        AST.LabeledStmt newast = new AST.LabeledStmt();
        Vector pair2 = PcalTranslate.CopyAndExplodeLastStmtWithGoto(new Vector(ast.stmts), next);
        Vector<AST.LabeledStmt> result = new Vector<AST.LabeledStmt>();
        newast.setOrigin(ast.getOrigin());
        newast.col = ast.col;
        newast.line = ast.line;
        newast.label = ast.label;
        newast.stmts = (Vector)pair2.elementAt(0);
        if (!ParseAlgorithm.omitPC) {
            newast.stmts.insertElementAt(PcalTranslate.CheckPC(newast.label), 0);
            result.addElement(newast);
        }
        result.addAll((Vector)pair2.elementAt(1));
        return result;
    }

    private static Vector ExplodeLabeledStmtSeq(Vector seq, String next) throws PcalTranslateException {
        Vector result = new Vector();
        for (int i = 0; i < seq.size(); ++i) {
            AST.LabeledStmt stmt = (AST.LabeledStmt)seq.elementAt(i);
            String nxt = i < seq.size() - 1 ? ((AST.LabeledStmt)seq.elementAt((int)(i + 1))).label : next;
            result.addAll(PcalTranslate.ExplodeLabeledStmt(stmt, nxt));
        }
        return result;
    }

    private static Vector ExplodeWhile(AST.LabeledStmt ast, String next) throws PcalTranslateException {
        Vector<AST.LabeledStmt> result = new Vector<AST.LabeledStmt>();
        AST.While w = (AST.While)ast.stmts.elementAt(0);
        AST.LabeledStmt newast = new AST.LabeledStmt();
        PCalLocation newastBeginLoc = ast.getOrigin().getBegin();
        PCalLocation whileBeginLoc = w.getOrigin().getBegin();
        PCalLocation whileBeginUnlabDoLoc = w.unlabDo.size() != 0 ? ((AST)w.unlabDo.elementAt(0)).getOrigin().getBegin() : w.test.getOrigin().getEnd();
        PCalLocation whileEndUnlabDoLoc = w.unlabDo.size() != 0 ? ((AST)w.unlabDo.elementAt(w.unlabDo.size() - 1)).getOrigin().getEnd() : w.test.getOrigin().getEnd();
        PCalLocation whileEndLoc = ast.stmts.size() != 1 ? ast.getOrigin().getEnd() : whileEndUnlabDoLoc;
        newast.setOrigin(new Region(newastBeginLoc, whileEndLoc));
        newast.col = ast.col;
        newast.line = ast.line;
        newast.label = ast.label;
        newast.stmts = new Vector();
        if (!ParseAlgorithm.omitPC) {
            newast.stmts.addElement(PcalTranslate.CheckPC(ast.label));
        }
        AST.LabeledStmt firstLS = w.labDo.size() == 0 ? null : (AST.LabeledStmt)w.labDo.elementAt(0);
        String unlabDoNext = firstLS == null ? ast.label : firstLS.label;
        Vector pair1 = PcalTranslate.CopyAndExplodeLastStmtWithGoto(new Vector(w.unlabDo), unlabDoNext);
        Vector rest = new Vector(ast.stmts);
        rest.remove(0);
        Vector pair2 = PcalTranslate.CopyAndExplodeLastStmtWithGoto(rest, next);
        if (PcalTranslate.IsTRUE(w.test)) {
            newast.stmts.addAll((Vector)pair1.elementAt(0));
        } else {
            AST.If ifS = new AST.If();
            ifS.test = w.test;
            ifS.Then = (Vector)pair1.elementAt(0);
            ifS.Else = (Vector)pair2.elementAt(0);
            ifS.setOrigin(new Region(whileBeginLoc, whileEndLoc));
            newast.stmts.addElement(ifS);
        }
        result.addElement(newast);
        for (int i = 0; i < w.labDo.size(); ++i) {
            AST.LabeledStmt nextLS = w.labDo.size() > i + 1 ? (AST.LabeledStmt)w.labDo.elementAt(i + 1) : null;
            String nextLSL = nextLS == null ? ast.label : nextLS.label;
            result.addAll(PcalTranslate.ExplodeLabeledStmt(firstLS, nextLSL));
            firstLS = nextLS;
        }
        result.addAll((Vector)pair1.elementAt(1));
        if (!PcalTranslate.IsTRUE(w.test)) {
            result.addAll((Vector)pair2.elementAt(1));
        }
        return result;
    }

    private static Vector ExplodeLabelIf(AST.LabelIf ast, String next) throws PcalTranslateException {
        int i = 0;
        Vector<AST.If> result1 = new Vector<AST.If>();
        Vector result2 = new Vector();
        AST.If newif = new AST.If();
        AST.LabeledStmt firstThen = ast.labThen.size() > 0 ? (AST.LabeledStmt)ast.labThen.elementAt(0) : null;
        AST.LabeledStmt firstElse = ast.labElse.size() > 0 ? (AST.LabeledStmt)ast.labElse.elementAt(0) : null;
        Vector explodedThen = PcalTranslate.CopyAndExplodeLastStmtWithGoto(ast.unlabThen, firstThen == null ? next : firstThen.label);
        Vector explodedElse = PcalTranslate.CopyAndExplodeLastStmtWithGoto(ast.unlabElse, firstElse == null ? next : firstElse.label);
        newif.test = ast.test;
        newif.col = ast.col;
        newif.line = ast.line;
        newif.Then = (Vector)explodedThen.elementAt(0);
        newif.Else = (Vector)explodedElse.elementAt(0);
        newif.setOrigin(ast.getOrigin());
        newif.setSource((ast.labThen.size() != 0 || ((Vector)explodedThen.elementAt(1)).size() != 0 ? 2 : 0) + (ast.labElse.size() != 0 || ((Vector)explodedElse.elementAt(1)).size() != 0 ? 4 : 0));
        result1.addElement(newif);
        AST.LabeledStmt nextThen = ast.labThen.size() > 1 ? (AST.LabeledStmt)ast.labThen.elementAt(1) : null;
        i = 0;
        while (i < ast.labThen.size()) {
            String nextThenLabel = nextThen == null ? next : nextThen.label;
            result2.addAll(PcalTranslate.ExplodeLabeledStmt(firstThen, nextThenLabel));
            firstThen = nextThen;
            nextThen = ast.labThen.size() > ++i + 1 ? (AST.LabeledStmt)ast.labThen.elementAt(i + 1) : null;
        }
        AST.LabeledStmt nextElse = ast.labElse.size() > 1 ? (AST.LabeledStmt)ast.labElse.elementAt(1) : null;
        i = 0;
        while (i < ast.labElse.size()) {
            String nextElseLabel = nextElse == null ? next : nextElse.label;
            result2.addAll(PcalTranslate.ExplodeLabeledStmt(firstElse, nextElseLabel));
            firstElse = nextElse;
            nextElse = ast.labElse.size() > ++i + 1 ? (AST.LabeledStmt)ast.labElse.elementAt(i + 1) : null;
        }
        result2.addAll((Vector)explodedThen.elementAt(1));
        result2.addAll((Vector)explodedElse.elementAt(1));
        return PcalTranslate.Pair(result1, result2);
    }

    private static Vector ExplodeLabelEither(AST.LabelEither ast, String next) throws PcalTranslateException {
        Vector<AST.Either> result1 = new Vector<AST.Either>();
        Vector result2 = new Vector();
        AST.Either newEither = new AST.Either();
        newEither.col = ast.col;
        newEither.line = ast.line;
        newEither.setOrigin(ast.getOrigin());
        newEither.ors = new Vector();
        for (int i = 0; i < ast.clauses.size(); ++i) {
            AST.Clause clause = (AST.Clause)ast.clauses.elementAt(i);
            Vector res = PcalTranslate.CopyAndExplodeLastStmtWithGoto(clause.unlabOr, clause.labOr.size() > 0 ? ((AST.LabeledStmt)clause.labOr.elementAt((int)0)).label : next);
            if (clause.labOr.size() != 0 || ((Vector)res.elementAt(1)).size() != 0) {
                clause.setBroken(true);
            }
            newEither.ors.addElement((Vector)res.elementAt(0));
            result2.addAll((Vector)res.elementAt(1));
            result2.addAll(PcalTranslate.ExplodeLabeledStmtSeq(clause.labOr, next));
        }
        result1.addElement(newEither);
        return PcalTranslate.Pair(result1, result2);
    }

    private static Vector ExplodeCall(AST.Call ast, String next) throws PcalTranslateException {
        AST.PVarDecl decl;
        int i;
        AST.PVarDecl decl2;
        int i2;
        Vector<AST.Assign> result = new Vector<AST.Assign>();
        int to = st.FindProc(ast.to);
        if (to == PcalTranslate.st.procs.size()) {
            throw new PcalTranslateException("Call of non-existent procedure " + ast.to, ast);
        }
        PcalSymTab.ProcedureEntry pe = (PcalSymTab.ProcedureEntry)PcalTranslate.st.procs.elementAt(to);
        AST.Assign ass = new AST.Assign();
        ass.ass = new Vector();
        ass.line = ast.line;
        ass.col = ast.col;
        AST.SingleAssign sass = new AST.SingleAssign();
        sass.line = ast.line;
        sass.col = ast.col;
        sass.lhs.var = "stack";
        sass.lhs.sub = PcalTranslate.MakeExpr(new Vector());
        TLAExpr expr = new TLAExpr();
        expr.addLine();
        expr.addToken(PcalTranslate.BuiltInToken("<<"));
        expr.addToken(PcalTranslate.BuiltInToken("["));
        expr.addToken(PcalTranslate.IdentToken("procedure"));
        expr.addToken(PcalTranslate.BuiltInToken("|->"));
        expr.addToken(PcalTranslate.StringToken(ast.to));
        expr.addToken(PcalTranslate.BuiltInToken(","));
        expr.addLine();
        expr.addToken(PcalTranslate.IdentToken("pc"));
        expr.addToken(PcalTranslate.BuiltInToken("|->"));
        expr.addToken(PcalTranslate.StringToken(next));
        for (i2 = 0; i2 < pe.decls.size(); ++i2) {
            decl2 = (AST.PVarDecl)pe.decls.elementAt(i2);
            expr.addToken(PcalTranslate.BuiltInToken(","));
            expr.addLine();
            expr.addToken(PcalTranslate.IdentToken(decl2.var));
            expr.addToken(PcalTranslate.BuiltInToken("|->"));
            expr.addToken(PcalTranslate.IdentToken(decl2.var));
        }
        for (i2 = 0; i2 < pe.params.size(); ++i2) {
            decl2 = (AST.PVarDecl)pe.params.elementAt(i2);
            expr.addToken(PcalTranslate.BuiltInToken(","));
            expr.addLine();
            expr.addToken(PcalTranslate.IdentToken(decl2.var));
            expr.addToken(PcalTranslate.BuiltInToken("|->"));
            expr.addToken(PcalTranslate.IdentToken(decl2.var));
        }
        expr.addToken(PcalTranslate.BuiltInToken("]"));
        expr.addToken(PcalTranslate.BuiltInToken(">>"));
        expr.addLine();
        expr.addToken(PcalTranslate.BuiltInToken("\\o"));
        expr.addToken(PcalTranslate.AddedToken("stack"));
        PcalTranslate.MakeNewStackTopExprPretty(expr);
        expr.normalize();
        sass.rhs = expr;
        ass.ass.addElement(sass);
        if (pe.params.size() != ast.args.size()) {
            throw new PcalTranslateException("Procedure " + ast.to + " called with wrong number of arguments", ast);
        }
        PCalLocation beginLoc = null;
        PCalLocation endLoc = null;
        for (i = 0; i < pe.params.size(); ++i) {
            decl = (AST.PVarDecl)pe.params.elementAt(i);
            if (i == 0) {
                beginLoc = decl.getOrigin().getBegin();
            }
            if (i == pe.params.size() - 1) {
                endLoc = decl.getOrigin().getEnd();
            }
            sass = new AST.SingleAssign();
            sass.line = ast.line;
            sass.col = ast.col;
            sass.setOrigin(decl.getOrigin());
            sass.lhs.var = decl.var;
            sass.lhs.sub = PcalTranslate.MakeExpr(new Vector());
            sass.rhs = (TLAExpr)ast.args.elementAt(i);
            ass.ass.addElement(sass);
        }
        if (beginLoc != null) {
            ass.setOrigin(new Region(beginLoc, endLoc));
        }
        result.addElement(ass);
        for (i = 0; i < pe.decls.size(); ++i) {
            ass = new AST.Assign();
            ass.ass = new Vector();
            ass.line = ast.line;
            ass.col = ast.col;
            decl = (AST.PVarDecl)pe.decls.elementAt(i);
            sass = new AST.SingleAssign();
            sass.line = ast.line;
            sass.col = ast.col;
            sass.setOrigin(decl.getOrigin());
            sass.lhs.var = decl.var;
            sass.lhs.sub = PcalTranslate.MakeExpr(new Vector());
            sass.rhs = decl.val;
            ass.setOrigin(decl.getOrigin());
            ass.ass.addElement(sass);
            result.addElement(ass);
        }
        result.addElement(PcalTranslate.UpdatePC(pe.iPC));
        return result;
    }

    private static Vector ExplodeReturn(AST.Return ast, String next) throws PcalTranslateException {
        AST.PVarDecl decl;
        int i;
        Vector<AST.Assign> result = new Vector<AST.Assign>();
        if (ast.from == null) {
            ast.from = currentProcedure;
        }
        if (ast.from == null) {
            throw new PcalTranslateException("`return' statement not in procedure", ast);
        }
        int from = st.FindProc(ast.from);
        if (from >= PcalTranslate.st.procs.size()) {
            throw new PcalTranslateException("Error in procedure (perhaps name used elsewhere)", ast);
        }
        PcalSymTab.ProcedureEntry pe = (PcalSymTab.ProcedureEntry)PcalTranslate.st.procs.elementAt(from);
        AST.Assign ass = new AST.Assign();
        ass.line = ast.line;
        ass.col = ast.col;
        AST.SingleAssign sass = new AST.SingleAssign();
        sass.line = ast.line;
        sass.col = ast.col;
        TLAExpr expr = new TLAExpr();
        sass.lhs.var = "pc";
        sass.lhs.sub = new TLAExpr();
        expr.addLine();
        expr.addToken(PcalTranslate.IdentToken("Head"));
        expr.addToken(PcalTranslate.BuiltInToken("("));
        expr.addToken(PcalTranslate.AddedToken("stack"));
        expr.addToken(PcalTranslate.BuiltInToken(")"));
        expr.addToken(PcalTranslate.BuiltInToken("."));
        expr.addToken(PcalTranslate.IdentToken("pc"));
        expr.normalize();
        sass.rhs = expr;
        ass.ass = PcalTranslate.Singleton(sass);
        result.addElement(ass);
        for (i = 0; i < pe.decls.size(); ++i) {
            decl = (AST.PVarDecl)pe.decls.elementAt(i);
            ass = new AST.Assign();
            ass.line = ast.line;
            ass.col = ast.col;
            sass = new AST.SingleAssign();
            sass.line = ast.line;
            sass.col = ast.col;
            expr = new TLAExpr();
            sass.lhs.var = decl.var;
            sass.lhs.sub = new TLAExpr();
            expr.addLine();
            expr.addToken(PcalTranslate.IdentToken("Head"));
            expr.addToken(PcalTranslate.BuiltInToken("("));
            expr.addToken(PcalTranslate.AddedToken("stack"));
            expr.addToken(PcalTranslate.BuiltInToken(")"));
            expr.addToken(PcalTranslate.BuiltInToken("."));
            expr.addToken(PcalTranslate.IdentToken(decl.var));
            expr.normalize();
            sass.rhs = expr;
            sass.setOrigin(ast.getOrigin());
            ass.setOrigin(ast.getOrigin());
            ass.ass = PcalTranslate.Singleton(sass);
            result.addElement(ass);
        }
        for (i = 0; i < pe.params.size(); ++i) {
            decl = (AST.PVarDecl)pe.params.elementAt(i);
            ass = new AST.Assign();
            ass.line = ast.line;
            ass.col = ast.col;
            sass = new AST.SingleAssign();
            sass.line = ast.line;
            sass.col = ast.col;
            sass.setOrigin(ast.getOrigin());
            ass.setOrigin(ast.getOrigin());
            expr = new TLAExpr();
            sass.lhs.var = decl.var;
            sass.lhs.sub = new TLAExpr();
            expr.addLine();
            expr.addToken(PcalTranslate.IdentToken("Head"));
            expr.addToken(PcalTranslate.BuiltInToken("("));
            expr.addToken(PcalTranslate.AddedToken("stack"));
            expr.addToken(PcalTranslate.BuiltInToken(")"));
            expr.addToken(PcalTranslate.BuiltInToken("."));
            expr.addToken(PcalTranslate.IdentToken(decl.var));
            expr.normalize();
            sass.rhs = expr;
            ass.ass = PcalTranslate.Singleton(sass);
            result.addElement(ass);
        }
        ass = new AST.Assign();
        ass.line = ast.line;
        ass.col = ast.col;
        sass = new AST.SingleAssign();
        sass.setOrigin(ast.getOrigin());
        ass.setOrigin(ast.getOrigin());
        sass.line = ast.line;
        sass.col = ast.col;
        expr = new TLAExpr();
        sass.lhs.var = "stack";
        sass.lhs.sub = new TLAExpr();
        expr.addLine();
        expr.addToken(PcalTranslate.IdentToken("Tail"));
        expr.addToken(PcalTranslate.BuiltInToken("("));
        expr.addToken(PcalTranslate.AddedToken("stack"));
        expr.addToken(PcalTranslate.BuiltInToken(")"));
        expr.normalize();
        sass.rhs = expr;
        ass.ass = PcalTranslate.Singleton(sass);
        result.addElement(ass);
        return result;
    }

    private static Vector ExplodeCallReturn(AST.CallReturn ast, String next) throws PcalTranslateException {
        AST.PVarDecl decl;
        int i;
        Vector<AST.Assign> result = new Vector<AST.Assign>();
        if (ast.from == null) {
            throw new PcalTranslateException("`return' statement following `call' at " + ast.location() + " not in a procedure");
        }
        int from = st.FindProc(ast.from);
        PcalSymTab.ProcedureEntry peFrom = (PcalSymTab.ProcedureEntry)PcalTranslate.st.procs.elementAt(from);
        int to = st.FindProc(ast.to);
        if (to == PcalTranslate.st.procs.size()) {
            throw new PcalTranslateException("Call of non-existent procedure " + ast.to, ast);
        }
        PcalSymTab.ProcedureEntry peTo = (PcalSymTab.ProcedureEntry)PcalTranslate.st.procs.elementAt(to);
        PcalDebug.Assert(from < PcalTranslate.st.procs.size());
        AST.Assign ass = new AST.Assign();
        ass.ass = new Vector();
        ass.line = ast.line;
        ass.col = ast.col;
        AST.SingleAssign sass = null;
        TLAExpr expr = null;
        if (!ast.from.equals(ast.to)) {
            AST.PVarDecl decl2;
            int i2;
            for (i2 = 0; i2 < peFrom.decls.size(); ++i2) {
                decl2 = (AST.PVarDecl)peFrom.decls.elementAt(i2);
                sass = new AST.SingleAssign();
                sass.line = ast.line;
                sass.col = ast.col;
                expr = new TLAExpr();
                sass.lhs.var = decl2.var;
                sass.lhs.sub = new TLAExpr();
                expr.addLine();
                expr.addToken(PcalTranslate.IdentToken("Head"));
                expr.addToken(PcalTranslate.BuiltInToken("("));
                expr.addToken(PcalTranslate.AddedToken("stack"));
                expr.addToken(PcalTranslate.BuiltInToken(")"));
                expr.addToken(PcalTranslate.BuiltInToken("."));
                expr.addToken(PcalTranslate.IdentToken(decl2.var));
                expr.normalize();
                sass.rhs = expr;
                ass.ass.addElement(sass);
            }
            sass = new AST.SingleAssign();
            sass.line = ast.line;
            sass.col = ast.col;
            sass.lhs.var = "stack";
            sass.lhs.sub = PcalTranslate.MakeExpr(new Vector());
            expr = new TLAExpr();
            expr.addLine();
            expr.addToken(PcalTranslate.BuiltInToken("<<"));
            expr.addToken(PcalTranslate.BuiltInToken("["));
            expr.addToken(PcalTranslate.IdentToken("procedure"));
            expr.addToken(PcalTranslate.BuiltInToken("|->"));
            expr.addToken(PcalTranslate.StringToken(ast.to));
            expr.addToken(PcalTranslate.BuiltInToken(","));
            expr.addLine();
            expr.addToken(PcalTranslate.IdentToken("pc"));
            expr.addToken(PcalTranslate.BuiltInToken("|->"));
            expr.addToken(PcalTranslate.IdentToken("Head"));
            expr.addToken(PcalTranslate.BuiltInToken("("));
            expr.addToken(PcalTranslate.AddedToken("stack"));
            expr.addToken(PcalTranslate.BuiltInToken(")"));
            expr.addToken(PcalTranslate.BuiltInToken("."));
            expr.addToken(PcalTranslate.IdentToken("pc"));
            for (i2 = 0; i2 < peTo.decls.size(); ++i2) {
                decl2 = (AST.PVarDecl)peTo.decls.elementAt(i2);
                expr.addToken(PcalTranslate.BuiltInToken(","));
                expr.addLine();
                expr.addToken(PcalTranslate.IdentToken(decl2.var));
                expr.addToken(PcalTranslate.BuiltInToken("|->"));
                expr.addToken(PcalTranslate.IdentToken(decl2.var));
            }
            for (i2 = 0; i2 < peTo.params.size(); ++i2) {
                decl2 = (AST.PVarDecl)peTo.params.elementAt(i2);
                expr.addToken(PcalTranslate.BuiltInToken(","));
                expr.addLine();
                expr.addToken(PcalTranslate.IdentToken(decl2.var));
                expr.addToken(PcalTranslate.BuiltInToken("|->"));
                expr.addToken(PcalTranslate.IdentToken(decl2.var));
            }
            expr.addToken(PcalTranslate.BuiltInToken("]"));
            expr.addToken(PcalTranslate.BuiltInToken(">>"));
            expr.addLine();
            expr.addToken(PcalTranslate.BuiltInToken("\\o"));
            expr.addToken(PcalTranslate.IdentToken("Tail"));
            expr.addToken(PcalTranslate.BuiltInToken("("));
            expr.addToken(PcalTranslate.AddedToken("stack"));
            expr.addToken(PcalTranslate.BuiltInToken(")"));
            PcalTranslate.MakeNewStackTopExprPretty(expr);
            expr.normalize();
            sass.rhs = expr;
            ass.ass.addElement(sass);
        }
        if (peTo.params.size() != ast.args.size()) {
            throw new PcalTranslateException("Procedure " + ast.to + " called with wrong number of arguments", ast);
        }
        PCalLocation beginLoc = null;
        PCalLocation endLoc = null;
        for (i = 0; i < peTo.params.size(); ++i) {
            decl = (AST.PVarDecl)peTo.params.elementAt(i);
            if (i == 0) {
                beginLoc = decl.getOrigin().getBegin();
            }
            if (i == peTo.params.size() - 1) {
                endLoc = decl.getOrigin().getEnd();
            }
            sass = new AST.SingleAssign();
            sass.line = ast.line;
            sass.col = ast.col;
            sass.lhs.var = decl.var;
            sass.lhs.sub = PcalTranslate.MakeExpr(new Vector());
            sass.rhs = (TLAExpr)ast.args.elementAt(i);
            ass.ass.addElement(sass);
        }
        if (beginLoc != null) {
            ass.setOrigin(new Region(beginLoc, endLoc));
        }
        result.addElement(ass);
        for (i = 0; i < peTo.decls.size(); ++i) {
            ass = new AST.Assign();
            ass.line = ast.line;
            ass.col = ast.col;
            ass.ass = new Vector();
            decl = (AST.PVarDecl)peTo.decls.elementAt(i);
            sass = new AST.SingleAssign();
            sass.line = ast.line;
            sass.col = ast.col;
            sass.setOrigin(decl.getOrigin());
            sass.lhs.var = decl.var;
            sass.lhs.sub = PcalTranslate.MakeExpr(new Vector());
            sass.rhs = decl.val;
            ass.setOrigin(decl.getOrigin());
            ass.ass.addElement(sass);
            result.addElement(ass);
        }
        result.addElement(PcalTranslate.UpdatePC(peTo.iPC));
        return result;
    }

    private static Vector ExplodeCallGoto(AST.CallGoto ast, String next) throws PcalTranslateException {
        AST.Call call = new AST.Call();
        call.to = ast.to;
        call.args = ast.args;
        call.line = ast.line;
        call.col = ast.col;
        call.setOrigin(ast.getOrigin());
        return PcalTranslate.ExplodeCall(call, ast.after);
    }

    public static class BoolObj {
        boolean val = true;
    }
}

