/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationComparator;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.debug.internal.core.LaunchConfigurationType;
import org.eclipse.debug.internal.core.LaunchDelegate;
import org.eclipse.debug.internal.core.LaunchMode;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.debug.internal.core.StepFilterManager;
import org.eclipse.debug.internal.core.sourcelookup.SourceContainerType;
import org.eclipse.debug.internal.core.sourcelookup.SourcePathComputer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchManager
extends PlatformObject
implements ILaunchManager,
IResourceChangeListener {
    protected static final String PREF_PREFERRED_DELEGATES = DebugPlugin.getUniqueIdentifier() + ".PREFERRED_DELEGATES";
    private static final String DEBUG_UI = "org.eclipse.debug.ui";
    static final String[] UNSUPPORTED_WIN32_CONFIG_NAMES = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
    static final char[] DISALLOWED_CONFIG_NAME_CHARS;
    protected static final IStatus promptStatus;
    private StepFilterManager fStepFilterManager = null;
    public static final int ADDED = 0;
    public static final int REMOVED = 1;
    public static final int CHANGED = 2;
    public static final int TERMINATE = 3;
    private static HashMap<String, String> fgNativeEnv;
    private static HashMap<String, String> fgNativeEnvCasePreserved;
    public static final IPath LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH;
    private List<ILaunchConfigurationType> fLaunchConfigurationTypes = null;
    private Map<ILaunchConfiguration, LaunchConfigurationInfo> fLaunchConfigurations = new HashMap<ILaunchConfiguration, LaunchConfigurationInfo>(10);
    private volatile String[] fSortedConfigNames = null;
    private List<ILaunchConfiguration> fLaunchConfigurationIndex = null;
    private Map<String, LaunchConfigurationComparator> fComparators = null;
    private Map<String, ILaunchMode> fLaunchModes = null;
    private HashMap<String, LaunchDelegate> fLaunchDelegates = null;
    private Set<PreferredDelegate> fPreferredDelegates = null;
    private List<ILaunch> fLaunches = new ArrayList<ILaunch>(10);
    private Set<ILaunch> fLaunchSet = new HashSet<ILaunch>(10);
    private ListenerList<ILaunchListener> fListeners = new ListenerList();
    private ListenerList<ILaunchesListener> fLaunchesListeners = new ListenerList();
    private LaunchManagerVisitor fgVisitor;
    private MappedResourceVisitor fgMRVisitor;
    private boolean fListening = false;
    private ListenerList<ILaunchConfigurationListener> fLaunchConfigurationListeners = new ListenerList();
    private Map<String, IConfigurationElement> fSourceLocators = null;
    private ILaunchConfiguration fFrom;
    private ILaunchConfiguration fTo;
    private Map<String, ISourceContainerType> sourceContainerTypes;
    private Map<String, ISourcePathComputer> sourcePathComputers;
    private Set<String> fActiveModes;

    static {
        char[] cArray = new char[12];
        cArray[0] = 64;
        cArray[1] = 38;
        cArray[2] = 92;
        cArray[3] = 47;
        cArray[4] = 58;
        cArray[5] = 42;
        cArray[6] = 63;
        cArray[7] = 34;
        cArray[8] = 60;
        cArray[9] = 62;
        cArray[10] = 124;
        DISALLOWED_CONFIG_NAME_CHARS = cArray;
        promptStatus = new Status(1, DEBUG_UI, 200, "", null);
        fgNativeEnv = null;
        fgNativeEnvCasePreserved = null;
        LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH = DebugPlugin.getDefault().getStateLocation().append(".launches");
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilder docBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
        return docBuilder.newDocument();
    }

    public static String serializeDocument(Document doc) throws TransformerException, IOException {
        return LaunchManager.serializeDocument(doc, System.lineSeparator());
    }

    public static String serializeDocument(Document doc, String lineDelimiter) throws TransformerException, IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString(StandardCharsets.UTF_8).replace(System.lineSeparator(), lineDelimiter);
    }

    @Override
    public void addLaunch(ILaunch launch) {
        if (this.internalAddLaunch(launch)) {
            this.fireUpdate(launch, 0);
            this.fireUpdate(new ILaunch[]{launch}, 0);
        }
    }

    @Override
    public void addLaunchConfigurationListener(ILaunchConfigurationListener listener) {
        this.fLaunchConfigurationListeners.add((Object)listener);
    }

    @Override
    public void addLaunches(ILaunch[] launches) {
        ArrayList<ILaunch> added = new ArrayList<ILaunch>(launches.length);
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (this.internalAddLaunch(launch)) {
                added.add(launch);
            }
            ++n2;
        }
        if (!added.isEmpty()) {
            ILaunch[] addedLaunches = added.toArray(new ILaunch[added.size()]);
            this.fireUpdate(addedLaunches, 0);
            int i = 0;
            while (i < addedLaunches.length) {
                this.fireUpdate(launches[i], 0);
                ++i;
            }
        }
    }

    @Override
    public void addLaunchListener(ILaunchesListener listener) {
        this.fLaunchesListeners.add((Object)listener);
    }

    @Override
    public void addLaunchListener(ILaunchListener listener) {
        this.fListeners.add((Object)listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cacheNativeEnvironment(Map<String, String> cache) {
        try {
            Object nativeCommand = null;
            boolean isWin9xME = false;
            String fileName = null;
            if (Platform.getOS().equals("win32")) {
                String osName = System.getProperty("os.name");
                boolean bl = isWin9xME = osName != null && (osName.startsWith("Windows 9") || osName.startsWith("Windows ME"));
                if (isWin9xME) {
                    IPath stateLocation = DebugPlugin.getDefault().getStateLocation();
                    fileName = stateLocation.toOSString() + File.separator + "env.txt";
                    nativeCommand = "command.com /C set > " + fileName;
                } else {
                    nativeCommand = "cmd.exe /C set";
                }
            } else if (!Platform.getOS().equals("unknown")) {
                nativeCommand = "env";
            }
            if (nativeCommand == null) {
                return;
            }
            Process process = Runtime.getRuntime().exec((String)nativeCommand);
            if (isWin9xME) {
                Properties p = new Properties();
                File file = new File(fileName);
                Throwable throwable = null;
                Object var9_16 = null;
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    p.load(stream);
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                    Iterator<Map.Entry<Object, Object>> iterator = p.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        Map.Entry<Object, Object> entry = iterator.next();
                        String key = (String)entry.getKey();
                        cache.put(key, (String)p.get(key));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                InputStream stream = process.getInputStream();
                try {
                    block47: {
                        InputStreamReader isreader = new InputStreamReader(stream);
                        try {
                            try (BufferedReader reader = new BufferedReader(isreader);){
                                String line = reader.readLine();
                                String key = null;
                                Object value = null;
                                String newLine = System.lineSeparator();
                                while (line != null) {
                                    block45: {
                                        int func = line.indexOf("=()");
                                        if (func > 0) {
                                            key = line.substring(0, func);
                                            value = line.substring(func + 1);
                                            while (true) {
                                                if (line == null || line.equals("}")) {
                                                    line = reader.readLine();
                                                    break block45;
                                                }
                                                line = reader.readLine();
                                                if (line == null) continue;
                                                value = (String)value + newLine + line;
                                            }
                                        }
                                        int separator = line.indexOf(61);
                                        if (separator > 0) {
                                            key = line.substring(0, separator);
                                            value = line.substring(separator + 1);
                                            line = reader.readLine();
                                            if (line != null) {
                                                while (line.indexOf(61) < 0 || line.length() > 0 && !Character.isJavaIdentifierStart(line.charAt(0))) {
                                                    value = (String)value + newLine + line;
                                                    line = reader.readLine();
                                                    if (line != null) continue;
                                                }
                                            }
                                        }
                                    }
                                    if (key != null) {
                                        cache.put(key, (String)value);
                                        key = null;
                                        value = null;
                                        continue;
                                    }
                                    line = reader.readLine();
                                }
                            }
                            if (isreader == null) break block47;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (isreader == null) throw throwable;
                            isreader.close();
                            throw throwable;
                        }
                        isreader.close();
                    }
                    if (stream == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private void clearAllLaunchConfigurations() {
        if (this.fLaunchConfigurationTypes != null) {
            this.fLaunchConfigurationTypes.clear();
        }
        if (this.fLaunchConfigurationIndex != null) {
            this.fLaunchConfigurationIndex.clear();
        }
    }

    @Override
    public String getEncoding(ILaunchConfiguration configuration) throws CoreException {
        boolean forceSystemEncoding = configuration.getAttribute("org.eclipse.debug.core.ATTR_FORCE_SYSTEM_CONSOLE_ENCODING", false);
        if (forceSystemEncoding) {
            return Platform.getSystemCharset().name();
        }
        String encoding = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", (String)null);
        if (encoding == null) {
            IResource[] resources = configuration.getMappedResources();
            if (resources != null && resources.length > 0) {
                IResource res = resources[0];
                if (res instanceof IFile) {
                    return ((IFile)res).getCharset();
                }
                if (res instanceof IContainer) {
                    return ((IContainer)res).getDefaultCharset();
                }
            } else {
                return ResourcesPlugin.getEncoding();
            }
        }
        return encoding;
    }

    protected synchronized void clearConfigNameCache() {
        this.fSortedConfigNames = null;
    }

    protected DebugException createDebugException(String message, Throwable throwable) {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, message, throwable));
    }

    protected LaunchConfigurationInfo createInfoFromXML(InputStream stream) throws CoreException, ParserConfigurationException, IOException, SAXException {
        return this.createInfoFromXML(stream, false);
    }

    protected LaunchConfigurationInfo createInfoFromXML(InputStream stream, boolean isPrototype) throws CoreException, ParserConfigurationException, IOException, SAXException {
        Element root = null;
        DocumentBuilder parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
        parser.setErrorHandler(new DefaultHandler());
        root = parser.parse(new InputSource(stream)).getDocumentElement();
        LaunchConfigurationInfo info = new LaunchConfigurationInfo();
        info.initializeFromXML(root, isPrototype);
        return info;
    }

    protected List<ILaunchConfiguration> findLaunchConfigurations(IContainer container) {
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return Collections.emptyList();
        }
        ArrayList<IResource> list = new ArrayList<IResource>(10);
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(list);
        try {
            container.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (CoreException coreException) {}
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>(list.size());
        for (IResource resource : list) {
            ILaunchConfiguration config = this.getLaunchConfiguration((IFile)resource);
            if (config == null || !config.exists()) continue;
            configs.add(config);
        }
        return configs;
    }

    public ILaunchConfiguration findLaunchConfiguration(String name) {
        if (name != null) {
            ILaunchConfiguration[] iLaunchConfigurationArray = this.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (name.equals(config.getName())) {
                    return config;
                }
                ++n2;
            }
        }
        return null;
    }

    protected List<ILaunchConfiguration> findLocalLaunchConfigurations() {
        IPath containerPath = LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH;
        File directory = containerPath.toFile();
        if (directory.isDirectory()) {
            FilenameFilter prototypeFilter;
            File[] prototypeFiles;
            ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
            FilenameFilter configFilter = (dir, name) -> dir.equals(directory) && name.endsWith("launch");
            File[] configFiles = directory.listFiles(configFilter);
            if (configFiles != null && configFiles.length > 0) {
                LaunchConfiguration config = null;
                File[] fileArray = configFiles;
                int n = configFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File configFile = fileArray[n2];
                    config = new LaunchConfiguration(LaunchConfiguration.getSimpleName(configFile.getName()), null, false);
                    configs.add(config);
                    ++n2;
                }
            }
            if ((prototypeFiles = directory.listFiles(prototypeFilter = (dir, name) -> dir.equals(directory) && name.endsWith("prototype"))) != null && prototypeFiles.length > 0) {
                LaunchConfiguration config = null;
                File[] fileArray = prototypeFiles;
                int n = prototypeFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    File prototypeFile = fileArray[n3];
                    config = new LaunchConfiguration(LaunchConfiguration.getSimpleName(prototypeFile.getName()), null, true);
                    configs.add(config);
                    ++n3;
                }
            }
            return configs;
        }
        return Collections.emptyList();
    }

    public void fireUpdate(ILaunch launch, int update) {
        new LaunchNotifier().notify(launch, update);
    }

    public void fireUpdate(ILaunch[] launches, int update) {
        new LaunchesNotifier().notify(launches, update);
    }

    @Override
    public String generateUniqueLaunchConfigurationNameFrom(String baseName) {
        String trailer;
        int index = 1;
        int length = baseName.length();
        int copyIndex = baseName.lastIndexOf(" (");
        String base = baseName;
        if (copyIndex > -1 && length > copyIndex + 2 && baseName.charAt(length - 1) == ')' && this.isNumber(trailer = baseName.substring(copyIndex + 2, length - 1))) {
            try {
                index = Integer.parseInt(trailer);
                base = baseName.substring(0, copyIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String newName = base;
        while (this.isExistingLaunchConfigurationName(newName)) {
            newName = MessageFormat.format(DebugCoreMessages.LaunchManager_31, base, Integer.toString(index));
            ++index;
        }
        return newName;
    }

    public String generateUniqueLaunchConfigurationNameFrom(String basename, Set<String> reservednames) {
        String trailer;
        if (reservednames == null) {
            return this.generateUniqueLaunchConfigurationNameFrom(basename);
        }
        int index = 1;
        int length = basename.length();
        String base = basename;
        int copyIndex = base.lastIndexOf(" (");
        if (copyIndex > -1 && length > copyIndex + 2 && base.charAt(length - 1) == ')' && this.isNumber(trailer = base.substring(copyIndex + 2, length - 1))) {
            try {
                index = Integer.parseInt(trailer);
                base = base.substring(0, copyIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String newname = base;
        StringBuilder buffer = null;
        while (this.isExistingLaunchConfigurationName(newname) || reservednames.contains(newname)) {
            buffer = new StringBuilder(base);
            buffer.append(" (");
            buffer.append(String.valueOf(index));
            ++index;
            buffer.append(')');
            newname = buffer.toString();
        }
        return newname;
    }

    public synchronized List<ILaunchConfiguration> getAllLaunchConfigurations() {
        if (this.fLaunchConfigurationIndex == null) {
            try {
                this.fLaunchConfigurationIndex = new ArrayList<ILaunchConfiguration>(20);
                List<ILaunchConfiguration> configs = this.findLocalLaunchConfigurations();
                this.verifyConfigurations(configs, this.fLaunchConfigurationIndex);
                configs = this.findLaunchConfigurations((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                this.verifyConfigurations(configs, this.fLaunchConfigurationIndex);
            }
            finally {
                this.hookResourceChangeListener();
            }
        }
        return this.fLaunchConfigurationIndex;
    }

    protected synchronized String[] getAllSortedConfigNames() {
        if (this.fSortedConfigNames == null) {
            List<ILaunchConfiguration> collection = this.getAllLaunchConfigurations();
            ILaunchConfiguration[] configs = collection.toArray(new ILaunchConfiguration[collection.size()]);
            this.fSortedConfigNames = new String[configs.length];
            int i = 0;
            while (i < configs.length) {
                this.fSortedConfigNames[i] = configs[i].getName();
                ++i;
            }
            Arrays.sort(this.fSortedConfigNames);
        }
        return this.fSortedConfigNames;
    }

    protected Comparator<Object> getComparator(String attributeName) {
        Map<String, LaunchConfigurationComparator> map = this.getComparators();
        return map.get(attributeName);
    }

    protected Map<String, LaunchConfigurationComparator> getComparators() {
        this.initializeComparators();
        return this.fComparators;
    }

    protected List<ILaunchConfiguration> getConfigsFromXML(Element root) throws CoreException {
        DebugException invalidFormat = new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchManager_Invalid_launch_configuration_index__18, null));
        if (!root.getNodeName().equalsIgnoreCase("launchConfigurations")) {
            throw invalidFormat;
        }
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>(4);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        Node node = null;
        Element entry = null;
        String memento = null;
        int i = 0;
        while (i < length) {
            node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                entry = (Element)node;
                if (!entry.getNodeName().equals("launchConfiguration")) {
                    throw invalidFormat;
                }
                memento = entry.getAttribute("memento");
                if (memento == null) {
                    throw invalidFormat;
                }
                configs.add(this.getLaunchConfiguration(memento));
            }
            ++i;
        }
        return configs;
    }

    protected ConfigurationNotifier getConfigurationNotifier() {
        return new ConfigurationNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDebugTarget[] getDebugTargets() {
        List<ILaunch> list = this.fLaunches;
        synchronized (list) {
            ArrayList allTargets = new ArrayList(this.fLaunches.size());
            IDebugTarget[] targets = null;
            for (ILaunch launch : this.fLaunches) {
                targets = launch.getDebugTargets();
                Collections.addAll(allTargets, targets);
            }
            return allTargets.toArray(new IDebugTarget[allTargets.size()]);
        }
    }

    private LaunchManagerVisitor getDeltaVisitor() {
        if (this.fgVisitor == null) {
            this.fgVisitor = new LaunchManagerVisitor();
        }
        return this.fgVisitor;
    }

    private MappedResourceVisitor getMappedResourceVisitor() {
        if (this.fgMRVisitor == null) {
            this.fgMRVisitor = new MappedResourceVisitor();
        }
        return this.fgMRVisitor;
    }

    @Override
    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        Map<String, String> configEnv = configuration.getAttribute(ATTR_ENVIRONMENT_VARIABLES, (Map<String, String>)null);
        if (configEnv == null) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        boolean append = configuration.getAttribute(ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        if (append) {
            env.putAll(this.getNativeEnvironmentCasePreserved());
        }
        boolean win32 = Platform.getOS().equals("win32");
        String key = null;
        String value = null;
        Object nativeValue = null;
        String nativeKey = null;
        for (Map.Entry<String, String> entry : configEnv.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (value != null) {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
            }
            boolean added = false;
            if (win32) {
                nativeValue = env.get(key);
                if (nativeValue != null) {
                    env.put(key, value);
                } else {
                    for (Map.Entry entry2 : env.entrySet()) {
                        nativeKey = (String)entry2.getKey();
                        if (!nativeKey.equalsIgnoreCase(key)) continue;
                        entry2.setValue(value);
                        added = true;
                        break;
                    }
                }
            }
            if (added) continue;
            env.put(key, value);
        }
        ArrayList<String> strings = new ArrayList<String>(env.size());
        StringBuilder buffer = null;
        for (Map.Entry entry : env.entrySet()) {
            buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LaunchConfigurationInfo getInfo(LaunchConfiguration config) throws CoreException {
        LaunchConfigurationInfo info = this.fLaunchConfigurations.get(config);
        if (info == null) {
            IFileStore store = config.getFileStore();
            if (config.exists()) {
                try {
                    Throwable throwable = null;
                    Object var5_10 = null;
                    try (BufferedInputStream stream = new BufferedInputStream(store.openInputStream(0, null));){
                        info = this.createInfoFromXML(stream, this.isPrototype(store));
                        LaunchManager launchManager = this;
                        synchronized (launchManager) {
                            this.fLaunchConfigurations.put(config, info);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    this.throwException(config, e);
                }
                catch (SAXException e) {
                    this.throwException(config, e);
                }
                catch (ParserConfigurationException e) {
                    this.throwException(config, e);
                }
                catch (IOException e) {
                    this.throwException(config, e);
                }
            } else {
                if (store != null) {
                    throw this.createDebugException(MessageFormat.format(DebugCoreMessages.LaunchManager_does_not_exist, config.getName(), store.toURI().toString()), null);
                }
                throw this.createDebugException(MessageFormat.format(DebugCoreMessages.LaunchManager_does_not_exist_no_store_found, config.getName()), null);
            }
        }
        return info;
    }

    private boolean isPrototype(IFileStore store) {
        return store.getName().endsWith(".prototype");
    }

    private boolean isPrototype(File file) {
        return file.getName().endsWith(".prototype");
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(IFile file) {
        this.hookResourceChangeListener();
        return new LaunchConfiguration(file);
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(String memento) throws CoreException {
        this.hookResourceChangeListener();
        return new LaunchConfiguration(memento);
    }

    @Override
    public synchronized ILaunchConfiguration[] getLaunchConfigurations() {
        return this.getLaunchConfigurations(1);
    }

    @Override
    public ILaunchConfiguration[] getLaunchConfigurations(int kinds) {
        List<ILaunchConfiguration> allConfigs = this.getAllLaunchConfigurations();
        if ((kinds & 1) > 0 && (kinds & 2) > 0) {
            return allConfigs.toArray(new ILaunchConfiguration[allConfigs.size()]);
        }
        ArrayList<ILaunchConfiguration> select = new ArrayList<ILaunchConfiguration>(allConfigs.size());
        for (ILaunchConfiguration config : allConfigs) {
            try {
                if ((config.getKind() & kinds) <= 0) continue;
                select.add(config);
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
        return select.toArray(new ILaunchConfiguration[select.size()]);
    }

    @Override
    public synchronized ILaunchConfiguration[] getLaunchConfigurations(ILaunchConfigurationType type) throws CoreException {
        return this.getLaunchConfigurations(type, 1);
    }

    @Override
    public synchronized ILaunchConfiguration[] getLaunchConfigurations(ILaunchConfigurationType type, int kinds) throws CoreException {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration config : this.getAllLaunchConfigurations()) {
            if (!config.getType().equals(type) || (config.getKind() & kinds) <= 0) continue;
            configs.add(config);
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    protected synchronized List<ILaunchConfiguration> getLaunchConfigurations(IProject project) {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration config : this.getAllLaunchConfigurations()) {
            IFile file = config.getFile();
            if (file == null || !file.getProject().equals((Object)project)) continue;
            configs.add(config);
        }
        return configs;
    }

    @Override
    public ILaunchConfigurationType getLaunchConfigurationType(String id) {
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = this.getLaunchConfigurationTypes();
        int n = iLaunchConfigurationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
            if (type.getIdentifier().equals(id)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ILaunchConfigurationType[] getLaunchConfigurationTypes() {
        this.initializeLaunchConfigurationTypes();
        return this.fLaunchConfigurationTypes.toArray(new ILaunchConfigurationType[this.fLaunchConfigurationTypes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILaunch[] getLaunches() {
        List<ILaunch> list = this.fLaunches;
        synchronized (list) {
            return this.fLaunches.toArray(new ILaunch[this.fLaunches.size()]);
        }
    }

    @Override
    public ILaunchMode getLaunchMode(String mode) {
        this.initializeLaunchModes();
        return this.fLaunchModes.get(mode);
    }

    @Override
    public ILaunchMode[] getLaunchModes() {
        this.initializeLaunchModes();
        Collection<ILaunchMode> collection = this.fLaunchModes.values();
        return collection.toArray(new ILaunchMode[collection.size()]);
    }

    public ILaunchDelegate[] getLaunchDelegates() {
        this.initializeLaunchDelegates();
        Collection<LaunchDelegate> col = this.fLaunchDelegates.values();
        return col.toArray(new ILaunchDelegate[col.size()]);
    }

    public LaunchDelegate[] getLaunchDelegates(String typeid) {
        this.initializeLaunchDelegates();
        ArrayList<LaunchDelegate> list = new ArrayList<LaunchDelegate>();
        for (Map.Entry<String, LaunchDelegate> entry : this.fLaunchDelegates.entrySet()) {
            LaunchDelegate ld = entry.getValue();
            if (!ld.getLaunchConfigurationTypeId().equals(typeid)) continue;
            list.add(ld);
        }
        return list.toArray(new LaunchDelegate[list.size()]);
    }

    public ILaunchDelegate getLaunchDelegate(String id) {
        if (id != null) {
            ILaunchDelegate[] iLaunchDelegateArray = this.getLaunchDelegates();
            int n = iLaunchDelegateArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchDelegate delegate = iLaunchDelegateArray[n2];
                if (id.equals(delegate.getId())) {
                    return delegate;
                }
                ++n2;
            }
        }
        return null;
    }

    private synchronized void initializeLaunchDelegates() {
        if (this.fLaunchDelegates == null) {
            IConfigurationElement info;
            this.fLaunchDelegates = new HashMap();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchDelegates");
            LaunchDelegate delegate = null;
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                info = iConfigurationElementArray[n2];
                delegate = new LaunchDelegate(info);
                this.fLaunchDelegates.put(delegate.getId(), delegate);
                ++n2;
            }
            extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchConfigurationTypes");
            iConfigurationElementArray = extensionPoint.getConfigurationElements();
            n = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n) {
                info = iConfigurationElementArray[n2];
                if (info.getAttribute("delegate") != null) {
                    delegate = new LaunchDelegate(info);
                    this.fLaunchDelegates.put(delegate.getId(), delegate);
                }
                ++n2;
            }
        }
    }

    private synchronized void initializePreferredDelegates() {
        if (this.fPreferredDelegates == null) {
            this.fPreferredDelegates = new HashSet<PreferredDelegate>();
            String preferred = Platform.getPreferencesService().getString(DebugPlugin.getUniqueIdentifier(), PREF_PREFERRED_DELEGATES, "", null);
            if (!"".equals(preferred)) {
                try {
                    Element root = DebugPlugin.parseDocument(preferred);
                    NodeList nodes = root.getElementsByTagName("delegate");
                    Element element = null;
                    String typeid = null;
                    HashSet<String> modeset = null;
                    int i = 0;
                    while (i < nodes.getLength()) {
                        String[] modes;
                        element = (Element)nodes.item(i);
                        String delegateid = element.getAttribute("id");
                        typeid = element.getAttribute("typeid");
                        LaunchDelegate delegate = this.getLaunchDelegateExtension(typeid, delegateid, modeset = new HashSet<String>(Arrays.asList(modes = element.getAttribute("modes").split(","))));
                        if (delegate != null && !"".equals(typeid) && modeset != null) {
                            this.fPreferredDelegates.add(new PreferredDelegate(delegate, typeid, modeset));
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DebugPlugin.log(e);
                }
            }
        }
    }

    protected void resetPreferredDelegates() {
        this.fPreferredDelegates = null;
    }

    protected ILaunchDelegate getPreferredDelegate(String typeid, Set<String> modes) {
        this.initializePreferredDelegates();
        for (PreferredDelegate pd : this.fPreferredDelegates) {
            if (!pd.getModes().equals(modes) || !pd.getTypeId().equals(typeid)) continue;
            return pd.getDelegate();
        }
        String preferred = Platform.getPreferencesService().getString(DebugPlugin.getUniqueIdentifier(), "//" + PREF_PREFERRED_DELEGATES + "/" + typeid, "", null);
        if (preferred != null && preferred.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(preferred, ";");
            while (tokenizer.hasMoreTokens()) {
                StringTokenizer tokenizer2 = new StringTokenizer(tokenizer.nextToken(), ",");
                String delegateId = tokenizer2.nextToken();
                HashSet<String> modeset = new HashSet<String>();
                while (tokenizer2.hasMoreTokens()) {
                    modeset.add(tokenizer2.nextToken());
                }
                LaunchDelegate delegate = this.getLaunchDelegateExtension(typeid, delegateId, modeset);
                if (delegate == null || !modeset.equals(modes)) continue;
                return delegate;
            }
        }
        return null;
    }

    private LaunchDelegate getLaunchDelegateExtension(String typeId, String id, Set<String> modeset) {
        LaunchDelegate[] launchDelegateArray = this.getLaunchDelegates(typeId);
        int n = launchDelegateArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<Set<String>> modesets;
            LaunchDelegate extension = launchDelegateArray[n2];
            if (id.equals(extension.getId()) && (modesets = extension.getModes()).contains(modeset)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    protected synchronized List<ILaunchConfiguration> getLocalLaunchConfigurations() {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration config : this.getAllLaunchConfigurations()) {
            if (!config.isLocal()) continue;
            configs.add(config);
        }
        return configs;
    }

    public ILaunchConfiguration[] getMappedConfigurations(IResource resource) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        block2: for (ILaunchConfiguration config : this.getAllLaunchConfigurations()) {
            try {
                IResource[] resources = config.getMappedResources();
                if (resources == null) continue;
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    if (res.equals((Object)resource)) {
                        configurations.add(config);
                        continue block2;
                    }
                    if (resource.getType() == 4 && res.getType() == 1 && res.getProject().equals((Object)resource)) {
                        configurations.add(config);
                        continue block2;
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                DebugPlugin.log(ce);
            }
        }
        return configurations.toArray(new ILaunchConfiguration[configurations.size()]);
    }

    @Override
    public ILaunchConfiguration[] getMigrationCandidates() throws CoreException {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration config : this.getAllLaunchConfigurations()) {
            if (config.isReadOnly() || !config.isMigrationCandidate()) continue;
            configs.add(config);
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    @Override
    public ILaunchConfiguration getMovedFrom(ILaunchConfiguration addedConfiguration) {
        if (addedConfiguration.equals(this.fTo)) {
            return this.fFrom;
        }
        return null;
    }

    @Override
    public ILaunchConfiguration getMovedTo(ILaunchConfiguration removedConfiguration) {
        if (removedConfiguration.equals(this.fFrom)) {
            return this.fTo;
        }
        return null;
    }

    @Override
    public synchronized Map<String, String> getNativeEnvironment() {
        if (fgNativeEnv == null) {
            Map<String, String> casePreserved = this.getNativeEnvironmentCasePreserved();
            if (Platform.getOS().equals("win32")) {
                fgNativeEnv = new HashMap();
                for (Map.Entry<String, String> entry : casePreserved.entrySet()) {
                    fgNativeEnv.put(entry.getKey().toUpperCase(), entry.getValue());
                }
            } else {
                fgNativeEnv = new HashMap<String, String>(casePreserved);
            }
        }
        return new HashMap<String, String>(fgNativeEnv);
    }

    @Override
    public synchronized Map<String, String> getNativeEnvironmentCasePreserved() {
        if (fgNativeEnvCasePreserved == null) {
            fgNativeEnvCasePreserved = new HashMap();
            this.cacheNativeEnvironment(fgNativeEnvCasePreserved);
        }
        return new HashMap<String, String>(fgNativeEnvCasePreserved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcess[] getProcesses() {
        List<ILaunch> list = this.fLaunches;
        synchronized (list) {
            ArrayList allProcesses = new ArrayList(this.fLaunches.size());
            IProcess[] processes = null;
            for (ILaunch launch : this.fLaunches) {
                processes = launch.getProcesses();
                Collections.addAll(allProcesses, processes);
            }
            return allProcesses.toArray(new IProcess[allProcesses.size()]);
        }
    }

    @Override
    public ISourceContainerType getSourceContainerType(String id) {
        this.initializeSourceContainerTypes();
        return this.sourceContainerTypes.get(id);
    }

    @Override
    public ISourceContainerType[] getSourceContainerTypes() {
        this.initializeSourceContainerTypes();
        Collection<ISourceContainerType> containers = this.sourceContainerTypes.values();
        return containers.toArray(new ISourceContainerType[containers.size()]);
    }

    @Override
    public ISourcePathComputer getSourcePathComputer(ILaunchConfiguration configuration) throws CoreException {
        String id = null;
        id = configuration.getAttribute(ISourcePathComputer.ATTR_SOURCE_PATH_COMPUTER_ID, (String)null);
        if (id == null) {
            return configuration.getType().getSourcePathComputer();
        }
        return this.getSourcePathComputer(id);
    }

    @Override
    public ISourcePathComputer getSourcePathComputer(String id) {
        this.initializeSourceContainerTypes();
        return this.sourcePathComputers.get(id);
    }

    private synchronized void hookResourceChangeListener() {
        if (!this.fListening) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 5);
            this.fListening = true;
        }
    }

    private synchronized void initializeComparators() {
        if (this.fComparators == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchConfigurationComparators");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fComparators = new HashMap<String, LaunchConfigurationComparator>(infos.length);
            IConfigurationElement configurationElement = null;
            String attr = null;
            IConfigurationElement[] iConfigurationElementArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement info = iConfigurationElementArray[n2];
                configurationElement = info;
                attr = configurationElement.getAttribute("attribute");
                if (attr != null) {
                    this.fComparators.put(attr, new LaunchConfigurationComparator(configurationElement));
                } else {
                    Status s = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format("Invalid launch configuration comparator extension defined by plug-in {0} - attribute not specified.", configurationElement.getContributor().getName()), null);
                    DebugPlugin.log((IStatus)s);
                }
                ++n2;
            }
        }
    }

    private synchronized void initializeLaunchConfigurationTypes() {
        if (this.fLaunchConfigurationTypes == null) {
            this.hookResourceChangeListener();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchConfigurationTypes");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchConfigurationTypes = new ArrayList<ILaunchConfigurationType>(infos.length);
            IConfigurationElement[] iConfigurationElementArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement info = iConfigurationElementArray[n2];
                this.fLaunchConfigurationTypes.add(new LaunchConfigurationType(info));
                ++n2;
            }
        }
    }

    private synchronized void initializeLaunchModes() {
        if (this.fLaunchModes == null) {
            try {
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchModes");
                IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
                this.fLaunchModes = new HashMap<String, ILaunchMode>();
                LaunchMode mode = null;
                IConfigurationElement[] iConfigurationElementArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement info = iConfigurationElementArray[n2];
                    mode = new LaunchMode(info);
                    this.fLaunchModes.put(mode.getIdentifier(), mode);
                    ++n2;
                }
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
    }

    private synchronized void initializeSourceContainerTypes() {
        if (this.sourceContainerTypes == null) {
            IConfigurationElement extension;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "sourceContainerTypes");
            IConfigurationElement[] extensions = extensionPoint.getConfigurationElements();
            this.sourceContainerTypes = new HashMap<String, ISourceContainerType>();
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                extension = iConfigurationElementArray[n2];
                this.sourceContainerTypes.put(extension.getAttribute("id"), new SourceContainerType(extension));
                ++n2;
            }
            extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "sourcePathComputers");
            extensions = extensionPoint.getConfigurationElements();
            this.sourcePathComputers = new HashMap<String, ISourcePathComputer>();
            iConfigurationElementArray = extensions;
            n = extensions.length;
            n2 = 0;
            while (n2 < n) {
                extension = iConfigurationElementArray[n2];
                this.sourcePathComputers.put(extension.getAttribute("id"), new SourcePathComputer(extension));
                ++n2;
            }
        }
    }

    private synchronized void initializeSourceLocators() {
        if (this.fSourceLocators == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "sourceLocators");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fSourceLocators = new HashMap<String, IConfigurationElement>(infos.length);
            IConfigurationElement configurationElement = null;
            String id = null;
            IConfigurationElement[] iConfigurationElementArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement info = iConfigurationElementArray[n2];
                configurationElement = info;
                id = configurationElement.getAttribute("id");
                if (id != null) {
                    this.fSourceLocators.put(id, configurationElement);
                } else {
                    Status s = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format("Invalid source locator extension defined by plug-in \"{0}\": \"id\" not specified.", configurationElement.getContributor().getName()), null);
                    DebugPlugin.log((IStatus)s);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAddLaunch(ILaunch launch) {
        this.getStepFilterManager();
        List<ILaunch> list = this.fLaunches;
        synchronized (list) {
            block4: {
                if (!this.fLaunches.contains(launch)) break block4;
                return false;
            }
            this.fLaunches.add(launch);
            this.fLaunchSet.add(launch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalRemoveLaunch(ILaunch launch) {
        if (launch == null) {
            return false;
        }
        List<ILaunch> list = this.fLaunches;
        synchronized (list) {
            this.fLaunchSet.remove(launch);
            return this.fLaunches.remove(launch);
        }
    }

    @Override
    public boolean isExistingLaunchConfigurationName(String name) {
        Object[] sortedConfigNames = this.getAllSortedConfigNames();
        int index = Arrays.binarySearch(sortedConfigNames, name);
        return index >= 0;
    }

    private boolean isNumber(String string) {
        int numChars = string.length();
        if (numChars == 0) {
            return false;
        }
        int i = 0;
        while (i < numChars) {
            if (!Character.isDigit(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isDeleteConfigurations() {
        return Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), "org.eclipse.debug.core.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegistered(ILaunch launch) {
        List<ILaunch> list = this.fLaunches;
        synchronized (list) {
            return this.fLaunchSet.contains(launch);
        }
    }

    protected boolean isValid(ILaunchConfiguration config) {
        try {
            config.getType();
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 5020) {
                DebugPlugin.log(e);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchConfigurationAdded(ILaunchConfiguration config) {
        if (config.isWorkingCopy()) {
            return;
        }
        if (this.isValid(config)) {
            boolean added = false;
            LaunchManager launchManager = this;
            synchronized (launchManager) {
                List<ILaunchConfiguration> allConfigs = this.getAllLaunchConfigurations();
                if (!allConfigs.contains(config)) {
                    allConfigs.add(config);
                    added = true;
                }
            }
            if (added) {
                this.getConfigurationNotifier().notify(config, 0);
                this.clearConfigNameCache();
            }
        } else {
            this.launchConfigurationDeleted(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchConfigurationChanged(ILaunchConfiguration config) {
        LaunchManager launchManager = this;
        synchronized (launchManager) {
            this.fLaunchConfigurations.remove(config);
        }
        this.clearConfigNameCache();
        if (this.isValid(config)) {
            this.launchConfigurationAdded(config);
            this.getConfigurationNotifier().notify(config, 2);
        } else {
            this.launchConfigurationDeleted(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchConfigurationDeleted(ILaunchConfiguration config) {
        boolean removed = false;
        LaunchManager launchManager = this;
        synchronized (launchManager) {
            LaunchConfigurationInfo key = this.fLaunchConfigurations.remove(config);
            removed = key != null;
            this.getAllLaunchConfigurations().remove(config);
        }
        if (removed) {
            this.getConfigurationNotifier().notify(config, 1);
            this.clearConfigNameCache();
        }
    }

    @Override
    public IPersistableSourceLocator newSourceLocator(String identifier) throws CoreException {
        this.initializeSourceLocators();
        IConfigurationElement config = this.fSourceLocators.get(identifier);
        if (config == null) {
            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format(DebugCoreMessages.LaunchManager_Source_locator_does_not_exist___0__13, identifier), null));
        }
        IPersistableSourceLocator sourceLocator = (IPersistableSourceLocator)config.createExecutableExtension("class");
        if (sourceLocator instanceof AbstractSourceLookupDirector) {
            ((AbstractSourceLookupDirector)sourceLocator).setId(identifier);
        }
        return sourceLocator;
    }

    protected void projectClosed(IProject project) {
        this.terminateMappedConfigurations((IResource)project);
        for (ILaunchConfiguration config : this.getLaunchConfigurations(project)) {
            this.launchConfigurationDeleted(config);
        }
    }

    protected void projectOpened(IProject project) {
        for (ILaunchConfiguration config : this.findLaunchConfigurations((IContainer)project)) {
            this.launchConfigurationAdded(config);
        }
    }

    @Override
    public void removeLaunch(ILaunch launch) {
        if (this.internalRemoveLaunch(launch)) {
            this.fireUpdate(launch, 1);
            this.fireUpdate(new ILaunch[]{launch}, 1);
        }
    }

    @Override
    public void removeLaunchConfigurationListener(ILaunchConfigurationListener listener) {
        this.fLaunchConfigurationListeners.remove((Object)listener);
    }

    @Override
    public void removeLaunches(ILaunch[] launches) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>(launches.length);
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (this.internalRemoveLaunch(launch)) {
                removed.add(launch);
            }
            ++n2;
        }
        if (!removed.isEmpty()) {
            ILaunch[] removedLaunches = removed.toArray(new ILaunch[removed.size()]);
            this.fireUpdate(removedLaunches, 1);
            ILaunch[] iLaunchArray2 = removedLaunches;
            int n3 = removedLaunches.length;
            n = 0;
            while (n < n3) {
                ILaunch launch = iLaunchArray2[n];
                this.fireUpdate(launch, 1);
                ++n;
            }
        }
    }

    @Override
    public void removeLaunchListener(ILaunchesListener listener) {
        this.fLaunchesListeners.remove((Object)listener);
    }

    @Override
    public void removeLaunchListener(ILaunchListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            LaunchManagerVisitor visitor = this.getDeltaVisitor();
            MappedResourceVisitor v = null;
            if (this.isDeleteConfigurations()) {
                v = this.getMappedResourceVisitor();
            }
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
                if (v != null) {
                    delta.accept((IResourceDeltaVisitor)v);
                }
            }
            catch (CoreException e) {
                DebugPlugin.log(e.getStatus());
            }
        }
    }

    private ArrayList<ILaunchConfiguration> collectAssociatedLaunches(IResource resource) {
        ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            IResource[] resources = null;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.isLocal() && (resources = config.getMappedResources()) != null) {
                    IResource[] iResourceArray = resources;
                    int n3 = resources.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource res = iResourceArray[n4];
                        if (resource.equals((Object)res) || resource.getFullPath().isPrefixOf(res.getFullPath())) {
                            list.add(config);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
        return list;
    }

    protected void setMovedFromTo(ILaunchConfiguration from, ILaunchConfiguration to) {
        this.fFrom = from;
        this.fTo = to;
    }

    public void shutdown() {
        this.fListeners = new ListenerList();
        this.fLaunchesListeners = new ListenerList();
        this.fLaunchConfigurationListeners = new ListenerList();
        ILaunch[] iLaunchArray = this.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch != null) {
                try {
                    IDisconnect disconnect;
                    if (launch instanceof IDisconnect && (disconnect = (IDisconnect)((Object)launch)).canDisconnect()) {
                        disconnect.disconnect();
                    }
                    if (launch.canTerminate()) {
                        launch.terminate();
                    }
                }
                catch (DebugException e) {
                    DebugPlugin.log((Throwable)((Object)e));
                }
            }
            ++n2;
        }
        this.persistPreferredLaunchDelegates();
        this.clearAllLaunchConfigurations();
        this.fStepFilterManager = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void persistPreferredLaunchDelegates() {
        ILaunchConfigurationType[] types;
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = types = this.getLaunchConfigurationTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
            this.persistPreferredLaunchDelegate((LaunchConfigurationType)type);
            ++n2;
        }
    }

    public void persistPreferredLaunchDelegate(LaunchConfigurationType type) {
        String preferenceName = PREF_PREFERRED_DELEGATES + "/" + type.getIdentifier();
        Map<Set<String>, ILaunchDelegate> preferred = type.getPreferredDelegates();
        if (preferred != null && preferred.size() > 0) {
            StringBuilder str = new StringBuilder();
            for (Map.Entry<Set<String>, ILaunchDelegate> entry : preferred.entrySet()) {
                Set<String> modes = entry.getKey();
                ILaunchDelegate delegate = entry.getValue();
                if (delegate == null) continue;
                str.append(delegate.getId());
                str.append(',');
                for (String mode : modes) {
                    str.append(mode).append(',');
                }
                str.append(';');
            }
            Preferences.setString(DebugPlugin.getUniqueIdentifier(), preferenceName, str.toString(), null);
        } else {
            Preferences.setToDefault(DebugPlugin.getUniqueIdentifier(), preferenceName);
        }
        Preferences.setToDefault(DebugPlugin.getUniqueIdentifier(), PREF_PREFERRED_DELEGATES);
    }

    protected void terminateMappedConfigurations(IResource resource) {
        ILaunch[] launches = this.getLaunches();
        ILaunchConfiguration[] configs = this.getMappedConfigurations(resource);
        try {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n4];
                    if (config.equals(launch.getLaunchConfiguration()) && launch.canTerminate()) {
                        launch.terminate();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
    }

    private void throwException(LaunchConfiguration config, Throwable e) throws DebugException {
        String uri = config.getName();
        try {
            IFileStore store = config.getFileStore();
            if (store != null) {
                uri = store.toString();
            }
        }
        catch (CoreException coreException) {}
        throw this.createDebugException(MessageFormat.format(DebugCoreMessages.LaunchManager__0__occurred_while_reading_launch_configuration_file__1___1, e.toString(), uri), e);
    }

    protected void verifyConfigurations(List<ILaunchConfiguration> verify, List<ILaunchConfiguration> valid) {
        for (ILaunchConfiguration config : verify) {
            if (valid.contains(config) || !this.isValid(config)) continue;
            valid.add(config);
        }
    }

    public String getLaunchModeName(String id) {
        ILaunchMode launchMode = this.getLaunchMode(id);
        if (launchMode != null) {
            return LaunchManager.removeAccelerators(launchMode.getLabel());
        }
        return null;
    }

    public static String removeAccelerators(String label) {
        Object title = label;
        if (title != null) {
            int index = ((String)title).indexOf(38);
            if (index == 0) {
                title = ((String)title).substring(1);
            } else if (index > 0) {
                if (((String)title).charAt(index - 1) == '(' && ((String)title).length() >= index + 3 && ((String)title).charAt(index + 2) == ')') {
                    String first = ((String)title).substring(0, index - 1);
                    String last = ((String)title).substring(index + 3);
                    title = first + last;
                } else if (index < ((String)title).length() - 1) {
                    String first = ((String)title).substring(0, index);
                    String last = ((String)title).substring(index + 1);
                    title = first + last;
                }
            }
        }
        return title;
    }

    public synchronized StepFilterManager getStepFilterManager() {
        if (this.fStepFilterManager == null) {
            this.fStepFilterManager = new StepFilterManager();
        }
        return this.fStepFilterManager;
    }

    public void importConfigurations(File[] files, IProgressMonitor monitor) throws CoreException {
        HashMap<String, ILaunchConfiguration> sharedConfigs = new HashMap<String, ILaunchConfiguration>();
        for (ILaunchConfiguration config : this.getAllLaunchConfigurations()) {
            if (config.isLocal()) continue;
            StringBuilder buf = new StringBuilder(config.getName());
            buf.append('.');
            if (config.isPrototype()) {
                buf.append("prototype");
            } else {
                buf.append("launch");
            }
            sharedConfigs.put(buf.toString(), config);
        }
        ArrayList<Status> stati = null;
        SubMonitor lmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)DebugCoreMessages.LaunchManager_29, (int)files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File source = fileArray[n2];
            if (lmonitor.isCanceled()) break;
            lmonitor.subTask(MessageFormat.format(DebugCoreMessages.LaunchManager_28, source.getName()));
            IPath location = IPath.fromOSString((String)LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH.toOSString()).append(source.getName());
            File target = location.toFile();
            IPath locationdir = location.removeLastSegments(1);
            if (!locationdir.toFile().exists()) {
                locationdir.toFile().mkdirs();
            }
            boolean added = !target.exists();
            try {
                this.copyFile(source, target);
                LaunchConfiguration configuration = new LaunchConfiguration(LaunchConfiguration.getSimpleName(source.getName()), null, this.isPrototype(source));
                ILaunchConfiguration shared = (ILaunchConfiguration)sharedConfigs.get(target.getName());
                if (shared != null) {
                    this.setMovedFromTo(shared, configuration);
                    shared.delete();
                    this.launchConfigurationChanged(configuration);
                } else if (added) {
                    this.launchConfigurationAdded(configuration);
                } else {
                    this.launchConfigurationChanged(configuration);
                }
            }
            catch (IOException e) {
                if (stati == null) {
                    stati = new ArrayList<Status>();
                }
                stati.add(new Status(4, DebugPlugin.getUniqueIdentifier(), 125, MessageFormat.format(DebugCoreMessages.LaunchManager_27, source.getPath()), (Throwable)e));
            }
            lmonitor.worked(1);
            ++n2;
        }
        if (!lmonitor.isCanceled()) {
            lmonitor.done();
        }
        if (stati != null) {
            if (stati.size() > 1) {
                MultiStatus multi = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.LaunchManager_26, null);
                for (Status status : stati) {
                    multi.add((IStatus)status);
                }
                throw new CoreException((IStatus)multi);
            }
            throw new CoreException((IStatus)stati.get(0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(File in, File out) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileInputStream fis = new FileInputStream(in);
            try {
                try (FileOutputStream fos = new FileOutputStream(out);){
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = fis.read(buf)) != -1) {
                        fos.write(buf, 0, i);
                    }
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public synchronized boolean launchModeAvailable(String mode) {
        if (this.fActiveModes == null) {
            this.fActiveModes = new HashSet<String>(3);
            ILaunchConfigurationType[] iLaunchConfigurationTypeArray = this.getLaunchConfigurationTypes();
            int n = iLaunchConfigurationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
                ILaunchMode[] iLaunchModeArray = this.getLaunchModes();
                int n3 = iLaunchModeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILaunchMode launchMode = iLaunchModeArray[n4];
                    if (type.supportsMode(launchMode.getIdentifier())) {
                        this.fActiveModes.add(launchMode.getIdentifier());
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.fActiveModes.contains(mode);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public String generateLaunchConfigurationName(String namePrefix) {
        block5: {
            name = this.generateUniqueLaunchConfigurationNameFrom(namePrefix);
            try {
                this.isValidLaunchConfigurationName(name);
                return name;
            }
            catch (IllegalArgumentException v0) {
                if (!"win32".equals(Platform.getOS())) break block5;
                var6_3 /* !! */  = LaunchManager.UNSUPPORTED_WIN32_CONFIG_NAMES;
                var5_4 = LaunchManager.UNSUPPORTED_WIN32_CONFIG_NAMES.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                element = var6_3 /* !! */ [var4_5];
                if (element.equals(name)) {
                    name = "launch_configuration";
                }
                ++var4_5;
                continue;
            }
        }
        var6_3 /* !! */  = (String[])LaunchManager.DISALLOWED_CONFIG_NAME_CHARS;
        var5_4 = LaunchManager.DISALLOWED_CONFIG_NAME_CHARS.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            element = var6_3 /* !! */ [var4_5];
            name = name.replace((char)element, '_');
            ++var4_5;
        }
        return this.generateUniqueLaunchConfigurationNameFrom(name);
    }

    @Override
    public boolean isValidLaunchConfigurationName(String configname) throws IllegalArgumentException {
        int n;
        int n2;
        Object[] objectArray;
        if ("win32".equals(Platform.getOS())) {
            objectArray = UNSUPPORTED_WIN32_CONFIG_NAMES;
            n2 = UNSUPPORTED_WIN32_CONFIG_NAMES.length;
            n = 0;
            while (n < n2) {
                String element = objectArray[n];
                if (configname.equals(element)) {
                    throw new IllegalArgumentException(MessageFormat.format(DebugCoreMessages.LaunchManager_invalid_config_name, configname));
                }
                ++n;
            }
        }
        objectArray = DISALLOWED_CONFIG_NAME_CHARS;
        n2 = DISALLOWED_CONFIG_NAME_CHARS.length;
        n = 0;
        while (n < n2) {
            String element = objectArray[n];
            if (configname.indexOf((int)element) > -1) {
                throw new IllegalArgumentException(MessageFormat.format(DebugCoreMessages.LaunchManager_invalid_config_name_char, String.valueOf((char)element)));
            }
            ++n;
        }
        return true;
    }

    class ConfigurationNotifier
    implements ISafeRunnable {
        private ILaunchConfigurationListener fListener;
        private int fType;
        private ILaunchConfiguration fConfiguration;

        ConfigurationNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "An exception occurred during launch configuration change notification.", exception);
            DebugPlugin.log((IStatus)status);
        }

        public void notify(ILaunchConfiguration configuration, int update) {
            this.fConfiguration = configuration;
            this.fType = update;
            Iterator iterator = LaunchManager.this.fLaunchConfigurationListeners.iterator();
            while (iterator.hasNext()) {
                ILaunchConfigurationListener iLaunchConfigurationListener;
                this.fListener = iLaunchConfigurationListener = (ILaunchConfigurationListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fConfiguration = null;
            this.fListener = null;
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchConfigurationAdded(this.fConfiguration);
                    break;
                }
                case 1: {
                    this.fListener.launchConfigurationRemoved(this.fConfiguration);
                    break;
                }
                case 2: {
                    this.fListener.launchConfigurationChanged(this.fConfiguration);
                    break;
                }
            }
        }
    }

    class LaunchManagerVisitor
    implements IResourceDeltaVisitor {
        LaunchManagerVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x4000) != 0) {
                if (delta.getResource() instanceof IProject) {
                    IProject project = (IProject)delta.getResource();
                    if (project.isOpen()) {
                        LaunchManager.this.projectOpened(project);
                    } else {
                        LaunchManager.this.projectClosed(project);
                    }
                }
                return false;
            }
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if ("launch".equals(file.getFileExtension()) || "prototype".equals(file.getFileExtension())) {
                    LaunchConfiguration handle = new LaunchConfiguration(file);
                    switch (delta.getKind()) {
                        case 1: {
                            LaunchManager.this.launchConfigurationAdded(handle);
                            break;
                        }
                        case 2: {
                            LaunchManager.this.launchConfigurationDeleted(handle);
                            break;
                        }
                        case 4: {
                            LaunchManager.this.launchConfigurationChanged(handle);
                            break;
                        }
                    }
                }
                return false;
            }
            return true;
        }
    }

    class LaunchNotifier
    implements ISafeRunnable {
        private ILaunchListener fListener;
        private int fType;
        private ILaunch fLaunch;

        LaunchNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "An exception occurred during launch change notification.", exception);
            DebugPlugin.log((IStatus)status);
        }

        public void notify(ILaunch launch, int update) {
            this.fLaunch = launch;
            this.fType = update;
            Iterator iterator = LaunchManager.this.fListeners.iterator();
            while (iterator.hasNext()) {
                ILaunchListener iLaunchListener;
                this.fListener = iLaunchListener = (ILaunchListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fLaunch = null;
            this.fListener = null;
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchAdded(this.fLaunch);
                    break;
                }
                case 1: {
                    this.fListener.launchRemoved(this.fLaunch);
                    break;
                }
                case 2: {
                    if (!LaunchManager.this.isRegistered(this.fLaunch)) break;
                    this.fListener.launchChanged(this.fLaunch);
                    break;
                }
            }
        }
    }

    class LaunchesNotifier
    implements ISafeRunnable {
        private ILaunchesListener fListener;
        private int fType;
        private ILaunch[] fNotifierLaunches;
        private ILaunch[] fRegistered;

        LaunchesNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "An exception occurred during launch change notification.", exception);
            DebugPlugin.log((IStatus)status);
        }

        public void notify(ILaunch[] launches, int update) {
            this.fNotifierLaunches = launches;
            this.fType = update;
            this.fRegistered = null;
            Iterator iterator = LaunchManager.this.fLaunchesListeners.iterator();
            while (iterator.hasNext()) {
                ILaunchesListener iLaunchesListener;
                this.fListener = iLaunchesListener = (ILaunchesListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fNotifierLaunches = null;
            this.fRegistered = null;
            this.fListener = null;
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchesAdded(this.fNotifierLaunches);
                    break;
                }
                case 1: {
                    this.fListener.launchesRemoved(this.fNotifierLaunches);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.fRegistered == null) {
                        ArrayList<ILaunch> registered = null;
                        int j = 0;
                        while (j < this.fNotifierLaunches.length) {
                            if (LaunchManager.this.isRegistered(this.fNotifierLaunches[j])) {
                                if (registered != null) {
                                    registered.add(this.fNotifierLaunches[j]);
                                }
                            } else if (registered == null) {
                                registered = new ArrayList<ILaunch>(this.fNotifierLaunches.length);
                                int k = 0;
                                while (k < j) {
                                    registered.add(this.fNotifierLaunches[k]);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        this.fRegistered = registered == null ? this.fNotifierLaunches : registered.toArray(new ILaunch[registered.size()]);
                    }
                    if (this.fRegistered.length <= 0) break;
                    if (this.fType == 2) {
                        this.fListener.launchesChanged(this.fRegistered);
                    }
                    if (this.fType != 3 || !(this.fListener instanceof ILaunchesListener2)) break;
                    ((ILaunchesListener2)this.fListener).launchesTerminated(this.fRegistered);
                    break;
                }
            }
        }
    }

    class MappedResourceVisitor
    implements IResourceDeltaVisitor {
        MappedResourceVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if ((delta.getFlags() & 0x4000) != 0) {
                return false;
            }
            if (delta.getKind() == 2 && delta.getFlags() != 8192) {
                ArrayList<ILaunchConfiguration> configs = LaunchManager.this.collectAssociatedLaunches(delta.getResource());
                for (ILaunchConfiguration config : configs) {
                    try {
                        config.delete();
                    }
                    catch (CoreException e) {
                        DebugPlugin.log(e.getStatus());
                    }
                }
                return false;
            }
            return true;
        }
    }

    static class PreferredDelegate {
        private ILaunchDelegate fDelegate = null;
        private String fTypeid = null;
        private Set<String> fModes = null;

        public PreferredDelegate(ILaunchDelegate delegate, String typeid, Set<String> modes) {
            this.fDelegate = delegate;
            this.fTypeid = typeid;
            this.fModes = modes;
        }

        public String getTypeId() {
            return this.fTypeid;
        }

        public Set<String> getModes() {
            return this.fModes;
        }

        public ILaunchDelegate getDelegate() {
            return this.fDelegate;
        }
    }

    static class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private List<IResource> fList;

        protected ResourceProxyVisitor(List<IResource> list) {
            this.fList = list;
        }

        public boolean visit(IResourceProxy proxy) {
            if (proxy.getType() == 1) {
                if ("launch".equalsIgnoreCase(proxy.requestFullPath().getFileExtension()) || "prototype".equalsIgnoreCase(proxy.requestFullPath().getFileExtension())) {
                    this.fList.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }
}

